/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.bytecode.stackmap;

import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.ByteArray;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.bytecode.Descriptor;
import org.zeroturnaround.bundled.javassist.bytecode.Opcode;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData$ArrayElement;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData$ClassName;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData$NullType;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData$UninitData;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeData$UninitTypeVar;
import org.zeroturnaround.bundled.javassist.bytecode.stackmap.TypeTag;

public abstract class Tracer
implements TypeTag {
    protected ClassPool classPool;
    protected ConstPool cpool;
    protected String returnType;
    protected int stackTop;
    protected TypeData[] stackTypes;
    protected TypeData[] localsTypes;

    public Tracer(ClassPool classPool, ConstPool constPool, int n2, int n3, String string) {
        this.classPool = classPool;
        this.cpool = constPool;
        this.returnType = string;
        this.stackTop = 0;
        this.stackTypes = TypeData.make(n2);
        this.localsTypes = TypeData.make(n3);
    }

    public Tracer(Tracer tracer) {
        this.classPool = tracer.classPool;
        this.cpool = tracer.cpool;
        this.returnType = tracer.returnType;
        this.stackTop = tracer.stackTop;
        this.stackTypes = TypeData.make(tracer.stackTypes.length);
        this.localsTypes = TypeData.make(tracer.localsTypes.length);
    }

    protected int doOpcode(int n2, byte[] byArray) throws BadBytecode {
        try {
            int n3 = byArray[n2] & 0xFF;
            if (n3 < 96) {
                if (n3 < 54) {
                    return this.doOpcode0_53(n2, byArray, n3);
                }
                return this.doOpcode54_95(n2, byArray, n3);
            }
            if (n3 < 148) {
                return this.doOpcode96_147(n2, byArray, n3);
            }
            return this.doOpcode148_201(n2, byArray, n3);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new BadBytecode("inconsistent stack height " + arrayIndexOutOfBoundsException.getMessage());
        }
    }

    protected void visitBranch(int n2, byte[] byArray, int n3) throws BadBytecode {
    }

    protected void visitGoto(int n2, byte[] byArray, int n3) throws BadBytecode {
    }

    protected void visitReturn(int n2, byte[] byArray) throws BadBytecode {
    }

    protected void visitThrow(int n2, byte[] byArray) throws BadBytecode {
    }

    protected void visitTableSwitch(int n2, byte[] byArray, int n3, int n4, int n5) throws BadBytecode {
    }

    protected void visitLookupSwitch(int n2, byte[] byArray, int n3, int n4, int n5) throws BadBytecode {
    }

    protected void visitJSR(int n2, byte[] byArray) throws BadBytecode {
    }

    protected void visitRET(int n2, byte[] byArray) throws BadBytecode {
    }

    private int doOpcode0_53(int n2, byte[] byArray, int n3) throws BadBytecode {
        TypeData[] typeDataArray = this.stackTypes;
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                typeDataArray[this.stackTop++] = new TypeData$NullType();
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                typeDataArray[this.stackTop++] = INTEGER;
                break;
            }
            case 9: 
            case 10: {
                typeDataArray[this.stackTop++] = LONG;
                typeDataArray[this.stackTop++] = TOP;
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                typeDataArray[this.stackTop++] = FLOAT;
                break;
            }
            case 14: 
            case 15: {
                typeDataArray[this.stackTop++] = DOUBLE;
                typeDataArray[this.stackTop++] = TOP;
                break;
            }
            case 16: 
            case 17: {
                typeDataArray[this.stackTop++] = INTEGER;
                return n3 == 17 ? 3 : 2;
            }
            case 18: {
                this.doLDC(byArray[n2 + 1] & 0xFF);
                return 2;
            }
            case 19: 
            case 20: {
                this.doLDC(ByteArray.readU16bit(byArray, n2 + 1));
                return 3;
            }
            case 21: {
                return this.doXLOAD(INTEGER, byArray, n2);
            }
            case 22: {
                return this.doXLOAD(LONG, byArray, n2);
            }
            case 23: {
                return this.doXLOAD(FLOAT, byArray, n2);
            }
            case 24: {
                return this.doXLOAD(DOUBLE, byArray, n2);
            }
            case 25: {
                return this.doALOAD(byArray[n2 + 1] & 0xFF);
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                typeDataArray[this.stackTop++] = INTEGER;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                typeDataArray[this.stackTop++] = LONG;
                typeDataArray[this.stackTop++] = TOP;
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                typeDataArray[this.stackTop++] = FLOAT;
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                typeDataArray[this.stackTop++] = DOUBLE;
                typeDataArray[this.stackTop++] = TOP;
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                int n4 = n3 - 42;
                typeDataArray[this.stackTop++] = this.localsTypes[n4];
                break;
            }
            case 46: {
                typeDataArray[--this.stackTop - 1] = INTEGER;
                break;
            }
            case 47: {
                typeDataArray[this.stackTop - 2] = LONG;
                typeDataArray[this.stackTop - 1] = TOP;
                break;
            }
            case 48: {
                typeDataArray[--this.stackTop - 1] = FLOAT;
                break;
            }
            case 49: {
                typeDataArray[this.stackTop - 2] = DOUBLE;
                typeDataArray[this.stackTop - 1] = TOP;
                break;
            }
            case 50: {
                int n5 = --this.stackTop - 1;
                TypeData typeData = typeDataArray[n5];
                typeDataArray[n5] = TypeData$ArrayElement.make(typeData);
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                typeDataArray[--this.stackTop - 1] = INTEGER;
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    private void doLDC(int n2) {
        TypeData[] typeDataArray = this.stackTypes;
        int n3 = this.cpool.getTag(n2);
        if (n3 == 8) {
            typeDataArray[this.stackTop++] = new TypeData$ClassName("java.lang.String");
        } else if (n3 == 3) {
            typeDataArray[this.stackTop++] = INTEGER;
        } else if (n3 == 4) {
            typeDataArray[this.stackTop++] = FLOAT;
        } else if (n3 == 5) {
            typeDataArray[this.stackTop++] = LONG;
            typeDataArray[this.stackTop++] = TOP;
        } else if (n3 == 6) {
            typeDataArray[this.stackTop++] = DOUBLE;
            typeDataArray[this.stackTop++] = TOP;
        } else if (n3 == 7) {
            typeDataArray[this.stackTop++] = new TypeData$ClassName("java.lang.Class");
        } else {
            throw new RuntimeException("bad LDC: " + n3);
        }
    }

    private int doXLOAD(TypeData typeData, byte[] byArray, int n2) {
        int n3 = byArray[n2 + 1] & 0xFF;
        return this.doXLOAD(n3, typeData);
    }

    private int doXLOAD(int n2, TypeData typeData) {
        this.stackTypes[this.stackTop++] = typeData;
        if (typeData.is2WordType()) {
            this.stackTypes[this.stackTop++] = TOP;
        }
        return 2;
    }

    private int doALOAD(int n2) {
        this.stackTypes[this.stackTop++] = this.localsTypes[n2];
        return 2;
    }

    private int doOpcode54_95(int n2, byte[] byArray, int n3) throws BadBytecode {
        switch (n3) {
            case 54: {
                return this.doXSTORE(n2, byArray, INTEGER);
            }
            case 55: {
                return this.doXSTORE(n2, byArray, LONG);
            }
            case 56: {
                return this.doXSTORE(n2, byArray, FLOAT);
            }
            case 57: {
                return this.doXSTORE(n2, byArray, DOUBLE);
            }
            case 58: {
                return this.doASTORE(byArray[n2 + 1] & 0xFF);
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                int n4 = n3 - 59;
                this.localsTypes[n4] = INTEGER;
                --this.stackTop;
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                int n5 = n3 - 63;
                this.localsTypes[n5] = LONG;
                this.localsTypes[n5 + 1] = TOP;
                this.stackTop -= 2;
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                int n6 = n3 - 67;
                this.localsTypes[n6] = FLOAT;
                --this.stackTop;
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                int n7 = n3 - 71;
                this.localsTypes[n7] = DOUBLE;
                this.localsTypes[n7 + 1] = TOP;
                this.stackTop -= 2;
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                int n8 = n3 - 75;
                this.doASTORE(n8);
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: {
                this.stackTop -= n3 == 80 || n3 == 82 ? 4 : 3;
                break;
            }
            case 83: {
                TypeData$ArrayElement.aastore(this.stackTypes[this.stackTop - 3], this.stackTypes[this.stackTop - 1], this.classPool);
                this.stackTop -= 3;
                break;
            }
            case 84: 
            case 85: 
            case 86: {
                this.stackTop -= 3;
                break;
            }
            case 87: {
                --this.stackTop;
                break;
            }
            case 88: {
                this.stackTop -= 2;
                break;
            }
            case 89: {
                int n9 = this.stackTop;
                this.stackTypes[n9] = this.stackTypes[n9 - 1];
                this.stackTop = n9 + 1;
                break;
            }
            case 90: 
            case 91: {
                int n10 = n3 - 90 + 2;
                this.doDUP_XX(1, n10);
                int n11 = this.stackTop;
                this.stackTypes[n11 - n10] = this.stackTypes[n11];
                this.stackTop = n11 + 1;
                break;
            }
            case 92: {
                this.doDUP_XX(2, 2);
                this.stackTop += 2;
                break;
            }
            case 93: 
            case 94: {
                int n12 = n3 - 93 + 3;
                this.doDUP_XX(2, n12);
                int n13 = this.stackTop;
                this.stackTypes[n13 - n12] = this.stackTypes[n13];
                this.stackTypes[n13 - n12 + 1] = this.stackTypes[n13 + 1];
                this.stackTop = n13 + 2;
                break;
            }
            case 95: {
                int n14 = this.stackTop - 1;
                TypeData typeData = this.stackTypes[n14];
                this.stackTypes[n14] = this.stackTypes[n14 - 1];
                this.stackTypes[n14 - 1] = typeData;
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    private int doXSTORE(int n2, byte[] byArray, TypeData typeData) {
        int n3 = byArray[n2 + 1] & 0xFF;
        return this.doXSTORE(n3, typeData);
    }

    private int doXSTORE(int n2, TypeData typeData) {
        --this.stackTop;
        this.localsTypes[n2] = typeData;
        if (typeData.is2WordType()) {
            --this.stackTop;
            this.localsTypes[n2 + 1] = TOP;
        }
        return 2;
    }

    private int doASTORE(int n2) {
        --this.stackTop;
        this.localsTypes[n2] = this.stackTypes[this.stackTop];
        return 2;
    }

    private void doDUP_XX(int n2, int n3) {
        int n4;
        TypeData[] typeDataArray = this.stackTypes;
        int n5 = n4 - n3;
        for (n4 = this.stackTop - 1; n4 > n5; --n4) {
            typeDataArray[n4 + n2] = typeDataArray[n4];
        }
    }

    private int doOpcode96_147(int n2, byte[] byArray, int n3) {
        if (n3 <= 131) {
            this.stackTop += Opcode.STACK_GROW[n3];
            return 1;
        }
        switch (n3) {
            case 132: {
                return 3;
            }
            case 133: {
                this.stackTypes[this.stackTop - 1] = LONG;
                this.stackTypes[this.stackTop] = TOP;
                ++this.stackTop;
                break;
            }
            case 134: {
                this.stackTypes[this.stackTop - 1] = FLOAT;
                break;
            }
            case 135: {
                this.stackTypes[this.stackTop - 1] = DOUBLE;
                this.stackTypes[this.stackTop] = TOP;
                ++this.stackTop;
                break;
            }
            case 136: {
                this.stackTypes[--this.stackTop - 1] = INTEGER;
                break;
            }
            case 137: {
                this.stackTypes[--this.stackTop - 1] = FLOAT;
                break;
            }
            case 138: {
                this.stackTypes[this.stackTop - 2] = DOUBLE;
                break;
            }
            case 139: {
                this.stackTypes[this.stackTop - 1] = INTEGER;
                break;
            }
            case 140: {
                this.stackTypes[this.stackTop - 1] = LONG;
                this.stackTypes[this.stackTop] = TOP;
                ++this.stackTop;
                break;
            }
            case 141: {
                this.stackTypes[this.stackTop - 1] = DOUBLE;
                this.stackTypes[this.stackTop] = TOP;
                ++this.stackTop;
                break;
            }
            case 142: {
                this.stackTypes[--this.stackTop - 1] = INTEGER;
                break;
            }
            case 143: {
                this.stackTypes[this.stackTop - 2] = LONG;
                break;
            }
            case 144: {
                this.stackTypes[--this.stackTop - 1] = FLOAT;
                break;
            }
            case 145: 
            case 146: 
            case 147: {
                break;
            }
            default: {
                throw new RuntimeException("fatal");
            }
        }
        return 1;
    }

    private int doOpcode148_201(int n2, byte[] byArray, int n3) throws BadBytecode {
        switch (n3) {
            case 148: {
                this.stackTypes[this.stackTop - 4] = INTEGER;
                this.stackTop -= 3;
                break;
            }
            case 149: 
            case 150: {
                this.stackTypes[--this.stackTop - 1] = INTEGER;
                break;
            }
            case 151: 
            case 152: {
                this.stackTypes[this.stackTop - 4] = INTEGER;
                this.stackTop -= 3;
                break;
            }
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                --this.stackTop;
                this.visitBranch(n2, byArray, ByteArray.readS16bit(byArray, n2 + 1));
                return 3;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.stackTop -= 2;
                this.visitBranch(n2, byArray, ByteArray.readS16bit(byArray, n2 + 1));
                return 3;
            }
            case 167: {
                this.visitGoto(n2, byArray, ByteArray.readS16bit(byArray, n2 + 1));
                return 3;
            }
            case 168: {
                this.visitJSR(n2, byArray);
                return 3;
            }
            case 169: {
                this.visitRET(n2, byArray);
                return 2;
            }
            case 170: {
                --this.stackTop;
                int n4 = (n2 & 0xFFFFFFFC) + 8;
                int n5 = ByteArray.read32bit(byArray, n4);
                int n6 = ByteArray.read32bit(byArray, n4 + 4);
                int n7 = n6 - n5 + 1;
                this.visitTableSwitch(n2, byArray, n7, n4 + 8, ByteArray.read32bit(byArray, n4 - 4));
                return n7 * 4 + 16 - (n2 & 3);
            }
            case 171: {
                --this.stackTop;
                int n8 = (n2 & 0xFFFFFFFC) + 8;
                int n9 = ByteArray.read32bit(byArray, n8);
                this.visitLookupSwitch(n2, byArray, n9, n8 + 4, ByteArray.read32bit(byArray, n8 - 4));
                return n9 * 8 + 12 - (n2 & 3);
            }
            case 172: {
                --this.stackTop;
                this.visitReturn(n2, byArray);
                break;
            }
            case 173: {
                this.stackTop -= 2;
                this.visitReturn(n2, byArray);
                break;
            }
            case 174: {
                --this.stackTop;
                this.visitReturn(n2, byArray);
                break;
            }
            case 175: {
                this.stackTop -= 2;
                this.visitReturn(n2, byArray);
                break;
            }
            case 176: {
                this.stackTypes[--this.stackTop].setType(this.returnType, this.classPool);
                this.visitReturn(n2, byArray);
                break;
            }
            case 177: {
                this.visitReturn(n2, byArray);
                break;
            }
            case 178: {
                return this.doGetField(n2, byArray, false);
            }
            case 179: {
                return this.doPutField(n2, byArray, false);
            }
            case 180: {
                return this.doGetField(n2, byArray, true);
            }
            case 181: {
                return this.doPutField(n2, byArray, true);
            }
            case 182: 
            case 183: {
                return this.doInvokeMethod(n2, byArray, true);
            }
            case 184: {
                return this.doInvokeMethod(n2, byArray, false);
            }
            case 185: {
                return this.doInvokeIntfMethod(n2, byArray);
            }
            case 186: {
                return this.doInvokeDynamic(n2, byArray);
            }
            case 187: {
                int n10 = ByteArray.readU16bit(byArray, n2 + 1);
                this.stackTypes[this.stackTop++] = new TypeData$UninitData(n2, this.cpool.getClassInfo(n10));
                return 3;
            }
            case 188: {
                return this.doNEWARRAY(n2, byArray);
            }
            case 189: {
                int n11 = ByteArray.readU16bit(byArray, n2 + 1);
                String string = this.cpool.getClassInfo(n11).replace('.', '/');
                string = string.charAt(0) == '[' ? "[" + string : "[L" + string + ";";
                this.stackTypes[this.stackTop - 1] = new TypeData$ClassName(string);
                return 3;
            }
            case 190: {
                this.stackTypes[this.stackTop - 1].setType("[Ljava.lang.Object;", this.classPool);
                this.stackTypes[this.stackTop - 1] = INTEGER;
                break;
            }
            case 191: {
                this.stackTypes[--this.stackTop].setType("java.lang.Throwable", this.classPool);
                this.visitThrow(n2, byArray);
                break;
            }
            case 192: {
                int n12 = ByteArray.readU16bit(byArray, n2 + 1);
                String string = this.cpool.getClassInfo(n12);
                if (string.charAt(0) == '[') {
                    string = string.replace('.', '/');
                }
                this.stackTypes[this.stackTop - 1] = new TypeData$ClassName(string);
                return 3;
            }
            case 193: {
                this.stackTypes[this.stackTop - 1] = INTEGER;
                return 3;
            }
            case 194: 
            case 195: {
                --this.stackTop;
                break;
            }
            case 196: {
                return this.doWIDE(n2, byArray);
            }
            case 197: {
                return this.doMultiANewArray(n2, byArray);
            }
            case 198: 
            case 199: {
                --this.stackTop;
                this.visitBranch(n2, byArray, ByteArray.readS16bit(byArray, n2 + 1));
                return 3;
            }
            case 200: {
                this.visitGoto(n2, byArray, ByteArray.read32bit(byArray, n2 + 1));
                return 5;
            }
            case 201: {
                this.visitJSR(n2, byArray);
                return 5;
            }
        }
        return 1;
    }

    private int doWIDE(int n2, byte[] byArray) throws BadBytecode {
        int n3 = byArray[n2 + 1] & 0xFF;
        switch (n3) {
            case 21: {
                this.doWIDE_XLOAD(n2, byArray, INTEGER);
                break;
            }
            case 22: {
                this.doWIDE_XLOAD(n2, byArray, LONG);
                break;
            }
            case 23: {
                this.doWIDE_XLOAD(n2, byArray, FLOAT);
                break;
            }
            case 24: {
                this.doWIDE_XLOAD(n2, byArray, DOUBLE);
                break;
            }
            case 25: {
                int n4 = ByteArray.readU16bit(byArray, n2 + 2);
                this.doALOAD(n4);
                break;
            }
            case 54: {
                this.doWIDE_STORE(n2, byArray, INTEGER);
                break;
            }
            case 55: {
                this.doWIDE_STORE(n2, byArray, LONG);
                break;
            }
            case 56: {
                this.doWIDE_STORE(n2, byArray, FLOAT);
                break;
            }
            case 57: {
                this.doWIDE_STORE(n2, byArray, DOUBLE);
                break;
            }
            case 58: {
                int n5 = ByteArray.readU16bit(byArray, n2 + 2);
                this.doASTORE(n5);
                break;
            }
            case 132: {
                return 6;
            }
            case 169: {
                this.visitRET(n2, byArray);
                break;
            }
            default: {
                throw new RuntimeException("bad WIDE instruction: " + n3);
            }
        }
        return 4;
    }

    private void doWIDE_XLOAD(int n2, byte[] byArray, TypeData typeData) {
        int n3 = ByteArray.readU16bit(byArray, n2 + 2);
        this.doXLOAD(n3, typeData);
    }

    private void doWIDE_STORE(int n2, byte[] byArray, TypeData typeData) {
        int n3 = ByteArray.readU16bit(byArray, n2 + 2);
        this.doXSTORE(n3, typeData);
    }

    private int doPutField(int n2, byte[] byArray, boolean bl2) throws BadBytecode {
        int n3 = ByteArray.readU16bit(byArray, n2 + 1);
        String string = this.cpool.getFieldrefType(n3);
        this.stackTop -= Descriptor.dataSize(string);
        char c2 = string.charAt(0);
        if (c2 == 'L') {
            this.stackTypes[this.stackTop].setType(Tracer.getFieldClassName(string, 0), this.classPool);
        } else if (c2 == '[') {
            this.stackTypes[this.stackTop].setType(string, this.classPool);
        }
        this.setFieldTarget(bl2, n3);
        return 3;
    }

    private int doGetField(int n2, byte[] byArray, boolean bl2) throws BadBytecode {
        int n3 = ByteArray.readU16bit(byArray, n2 + 1);
        this.setFieldTarget(bl2, n3);
        String string = this.cpool.getFieldrefType(n3);
        this.pushMemberType(string);
        return 3;
    }

    private void setFieldTarget(boolean bl2, int n2) throws BadBytecode {
        if (bl2) {
            String string = this.cpool.getFieldrefClassName(n2);
            this.stackTypes[--this.stackTop].setType(string, this.classPool);
        }
    }

    private int doNEWARRAY(int n2, byte[] byArray) {
        String string;
        int n3 = this.stackTop - 1;
        switch (byArray[n2 + 1] & 0xFF) {
            case 4: {
                string = "[Z";
                break;
            }
            case 5: {
                string = "[C";
                break;
            }
            case 6: {
                string = "[F";
                break;
            }
            case 7: {
                string = "[D";
                break;
            }
            case 8: {
                string = "[B";
                break;
            }
            case 9: {
                string = "[S";
                break;
            }
            case 10: {
                string = "[I";
                break;
            }
            case 11: {
                string = "[J";
                break;
            }
            default: {
                throw new RuntimeException("bad newarray");
            }
        }
        this.stackTypes[n3] = new TypeData$ClassName(string);
        return 2;
    }

    private int doMultiANewArray(int n2, byte[] byArray) {
        int n3 = ByteArray.readU16bit(byArray, n2 + 1);
        int n4 = byArray[n2 + 3] & 0xFF;
        this.stackTop -= n4 - 1;
        String string = this.cpool.getClassInfo(n3).replace('.', '/');
        this.stackTypes[this.stackTop - 1] = new TypeData$ClassName(string);
        return 4;
    }

    private int doInvokeMethod(int n2, byte[] byArray, boolean bl2) throws BadBytecode {
        int n3 = ByteArray.readU16bit(byArray, n2 + 1);
        String string = this.cpool.getMethodrefType(n3);
        this.checkParamTypes(string, 1);
        if (bl2) {
            TypeData typeData;
            String string2 = this.cpool.getMethodrefClassName(n3);
            if ((typeData = this.stackTypes[--this.stackTop]) instanceof TypeData$UninitTypeVar && typeData.isUninit()) {
                this.constructorCalled(typeData, ((TypeData$UninitTypeVar)typeData).offset());
            } else if (typeData instanceof TypeData$UninitData) {
                this.constructorCalled(typeData, ((TypeData$UninitData)typeData).offset());
            }
            typeData.setType(string2, this.classPool);
        }
        this.pushMemberType(string);
        return 3;
    }

    private void constructorCalled(TypeData typeData, int n2) {
        int n3;
        typeData.constructorCalled(n2);
        for (n3 = 0; n3 < this.stackTop; ++n3) {
            this.stackTypes[n3].constructorCalled(n2);
        }
        for (n3 = 0; n3 < this.localsTypes.length; ++n3) {
            this.localsTypes[n3].constructorCalled(n2);
        }
    }

    private int doInvokeIntfMethod(int n2, byte[] byArray) throws BadBytecode {
        int n3 = ByteArray.readU16bit(byArray, n2 + 1);
        String string = this.cpool.getInterfaceMethodrefType(n3);
        this.checkParamTypes(string, 1);
        String string2 = this.cpool.getInterfaceMethodrefClassName(n3);
        this.stackTypes[--this.stackTop].setType(string2, this.classPool);
        this.pushMemberType(string);
        return 5;
    }

    private int doInvokeDynamic(int n2, byte[] byArray) throws BadBytecode {
        int n3 = ByteArray.readU16bit(byArray, n2 + 1);
        String string = this.cpool.getInvokeDynamicType(n3);
        this.checkParamTypes(string, 1);
        this.pushMemberType(string);
        return 5;
    }

    private void pushMemberType(String string) {
        int n2 = 0;
        if (string.charAt(0) == '(' && (n2 = string.indexOf(41) + 1) < 1) {
            throw new IndexOutOfBoundsException("bad descriptor: " + string);
        }
        TypeData[] typeDataArray = this.stackTypes;
        int n3 = this.stackTop;
        switch (string.charAt(n2)) {
            case '[': {
                typeDataArray[n3] = new TypeData$ClassName(string.substring(n2));
                break;
            }
            case 'L': {
                typeDataArray[n3] = new TypeData$ClassName(Tracer.getFieldClassName(string, n2));
                break;
            }
            case 'J': {
                typeDataArray[n3] = LONG;
                typeDataArray[n3 + 1] = TOP;
                this.stackTop += 2;
                return;
            }
            case 'F': {
                typeDataArray[n3] = FLOAT;
                break;
            }
            case 'D': {
                typeDataArray[n3] = DOUBLE;
                typeDataArray[n3 + 1] = TOP;
                this.stackTop += 2;
                return;
            }
            case 'V': {
                return;
            }
            default: {
                typeDataArray[n3] = INTEGER;
            }
        }
        ++this.stackTop;
    }

    private static String getFieldClassName(String string, int n2) {
        return string.substring(n2 + 1, string.length() - 1).replace('/', '.');
    }

    private void checkParamTypes(String string, int n2) throws BadBytecode {
        char c2 = string.charAt(n2);
        if (c2 == ')') {
            return;
        }
        int n3 = n2;
        boolean bl2 = false;
        while (c2 == '[') {
            bl2 = true;
            c2 = string.charAt(++n3);
        }
        if (c2 == 'L') {
            if ((n3 = string.indexOf(59, n3) + 1) <= 0) {
                throw new IndexOutOfBoundsException("bad descriptor");
            }
        } else {
            ++n3;
        }
        this.checkParamTypes(string, n3);
        this.stackTop = !(bl2 || c2 != 'J' && c2 != 'D') ? (this.stackTop -= 2) : --this.stackTop;
        if (bl2) {
            this.stackTypes[this.stackTop].setType(string.substring(n2, n3), this.classPool);
        } else if (c2 == 'L') {
            this.stackTypes[this.stackTop].setType(string.substring(n2 + 1, n3 - 1).replace('/', '.'), this.classPool);
        }
    }
}

