/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.compiler;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.CtBehavior;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.CtMember;
import org.zeroturnaround.bundled.javassist.CtMethod;
import org.zeroturnaround.bundled.javassist.CtPrimitiveType;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.bundled.javassist.bytecode.BadBytecode;
import org.zeroturnaround.bundled.javassist.bytecode.Bytecode;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.LocalVariableAttribute;
import org.zeroturnaround.bundled.javassist.compiler.CompileError;
import org.zeroturnaround.bundled.javassist.compiler.Javac$1;
import org.zeroturnaround.bundled.javassist.compiler.Javac$2;
import org.zeroturnaround.bundled.javassist.compiler.Javac$3;
import org.zeroturnaround.bundled.javassist.compiler.Javac$CtFieldWithInit;
import org.zeroturnaround.bundled.javassist.compiler.JvstCodeGen;
import org.zeroturnaround.bundled.javassist.compiler.Lex;
import org.zeroturnaround.bundled.javassist.compiler.MemberResolver;
import org.zeroturnaround.bundled.javassist.compiler.Parser;
import org.zeroturnaround.bundled.javassist.compiler.ProceedHandler;
import org.zeroturnaround.bundled.javassist.compiler.SymbolTable;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTList;
import org.zeroturnaround.bundled.javassist.compiler.ast.ASTree;
import org.zeroturnaround.bundled.javassist.compiler.ast.Declarator;
import org.zeroturnaround.bundled.javassist.compiler.ast.FieldDecl;
import org.zeroturnaround.bundled.javassist.compiler.ast.MethodDecl;
import org.zeroturnaround.bundled.javassist.compiler.ast.Stmnt;

public class Javac {
    JvstCodeGen gen;
    SymbolTable stable;
    private Bytecode bytecode;
    public static final String param0Name = "$0";
    public static final String resultVarName = "$_";
    public static final String proceedName = "$proceed";

    public Javac(CtClass ctClass) {
        this(new Bytecode(ctClass.getClassFile2().getConstPool(), 0, 0), ctClass);
    }

    public Javac(Bytecode bytecode, CtClass ctClass) {
        this.gen = new JvstCodeGen(bytecode, ctClass, ctClass.getClassPool());
        this.stable = new SymbolTable();
        this.bytecode = bytecode;
    }

    public Bytecode getBytecode() {
        return this.bytecode;
    }

    public CtMember compile(String string) throws CompileError {
        Parser parser = new Parser(new Lex(string));
        ASTList aSTList = parser.parseMember1(this.stable);
        try {
            if (aSTList instanceof FieldDecl) {
                return this.compileField((FieldDecl)aSTList);
            }
            CtBehavior ctBehavior = this.compileMethod(parser, (MethodDecl)aSTList);
            CtClass ctClass = ctBehavior.getDeclaringClass();
            ctBehavior.getMethodInfo2().rebuildStackMapIf6(ctClass.getClassPool(), ctClass.getClassFile2());
            return ctBehavior;
        }
        catch (BadBytecode badBytecode) {
            throw new CompileError(badBytecode.getMessage());
        }
        catch (CannotCompileException cannotCompileException) {
            throw new CompileError(cannotCompileException.getMessage());
        }
    }

    private CtField compileField(FieldDecl fieldDecl) throws CompileError, CannotCompileException {
        Declarator declarator = fieldDecl.getDeclarator();
        Javac$CtFieldWithInit javac$CtFieldWithInit = new Javac$CtFieldWithInit(this.gen.resolver.lookupClass(declarator), declarator.getVariable().get(), this.gen.getThisClass());
        javac$CtFieldWithInit.setModifiers(MemberResolver.getModifiers(fieldDecl.getModifiers()));
        if (fieldDecl.getInit() != null) {
            javac$CtFieldWithInit.setInit(fieldDecl.getInit());
        }
        return javac$CtFieldWithInit;
    }

    private CtBehavior compileMethod(Parser parser, MethodDecl methodDecl) throws CompileError {
        int n2 = MemberResolver.getModifiers(methodDecl.getModifiers());
        CtClass[] ctClassArray = this.gen.makeParamList(methodDecl);
        CtClass[] ctClassArray2 = this.gen.makeThrowsList(methodDecl);
        this.recordParams(ctClassArray, Modifier.isStatic(n2));
        methodDecl = parser.parseMethod2(this.stable, methodDecl);
        try {
            if (methodDecl.isConstructor()) {
                CtConstructor ctConstructor = new CtConstructor(ctClassArray, this.gen.getThisClass());
                ctConstructor.setModifiers(n2);
                methodDecl.accept(this.gen);
                ctConstructor.getMethodInfo().setCodeAttribute(this.bytecode.toCodeAttribute());
                ctConstructor.setExceptionTypes(ctClassArray2);
                return ctConstructor;
            }
            Declarator declarator = methodDecl.getReturn();
            CtClass ctClass = this.gen.resolver.lookupClass(declarator);
            this.recordReturnType(ctClass, false);
            CtMethod ctMethod = new CtMethod(ctClass, declarator.getVariable().get(), ctClassArray, this.gen.getThisClass());
            ctMethod.setModifiers(n2);
            this.gen.setThisMethod(ctMethod);
            methodDecl.accept(this.gen);
            if (methodDecl.getBody() != null) {
                ctMethod.getMethodInfo().setCodeAttribute(this.bytecode.toCodeAttribute());
            } else {
                ctMethod.setModifiers(n2 | 0x400);
            }
            ctMethod.setExceptionTypes(ctClassArray2);
            return ctMethod;
        }
        catch (NotFoundException notFoundException) {
            throw new CompileError(notFoundException.toString());
        }
    }

    public Bytecode compileBody(CtBehavior ctBehavior, String string) throws CompileError {
        try {
            boolean bl2;
            CtClass ctClass;
            int n2 = ctBehavior.getModifiers();
            this.recordParams(ctBehavior.getParameterTypes(), Modifier.isStatic(n2));
            if (ctBehavior instanceof CtMethod) {
                this.gen.setThisMethod((CtMethod)ctBehavior);
                ctClass = ((CtMethod)ctBehavior).getReturnType();
            } else {
                ctClass = CtClass.voidType;
            }
            this.recordReturnType(ctClass, false);
            boolean bl3 = bl2 = ctClass == CtClass.voidType;
            if (string == null) {
                Javac.makeDefaultBody(this.bytecode, ctClass);
            } else {
                Parser parser = new Parser(new Lex(string));
                SymbolTable symbolTable = new SymbolTable(this.stable);
                Stmnt stmnt = parser.parseStatement(symbolTable);
                if (parser.hasMore()) {
                    throw new CompileError("the method/constructor body must be surrounded by {}");
                }
                boolean bl4 = false;
                if (ctBehavior instanceof CtConstructor) {
                    bl4 = !((CtConstructor)ctBehavior).isClassInitializer();
                }
                this.gen.atMethodBody(stmnt, bl4, bl2);
            }
            return this.bytecode;
        }
        catch (NotFoundException notFoundException) {
            throw new CompileError(notFoundException.toString());
        }
    }

    private static void makeDefaultBody(Bytecode bytecode, CtClass ctClass) {
        int n2;
        int n3;
        if (ctClass instanceof CtPrimitiveType) {
            CtPrimitiveType ctPrimitiveType = (CtPrimitiveType)ctClass;
            n3 = ctPrimitiveType.getReturnOp();
            n2 = n3 == 175 ? 14 : (n3 == 174 ? 11 : (n3 == 173 ? 9 : (n3 == 177 ? 0 : 3)));
        } else {
            n3 = 176;
            n2 = 1;
        }
        if (n2 != 0) {
            bytecode.addOpcode(n2);
        }
        bytecode.addOpcode(n3);
    }

    public boolean recordLocalVariables(CodeAttribute codeAttribute, int n2) throws CompileError {
        LocalVariableAttribute localVariableAttribute = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        if (localVariableAttribute == null) {
            return false;
        }
        int n3 = localVariableAttribute.tableLength();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = localVariableAttribute.startPc(i2);
            int n5 = localVariableAttribute.codeLength(i2);
            if (n4 > n2 || n2 >= n4 + n5) continue;
            this.gen.recordVariable(localVariableAttribute.descriptor(i2), localVariableAttribute.variableName(i2), localVariableAttribute.index(i2), this.stable);
        }
        return true;
    }

    public boolean recordParamNames(CodeAttribute codeAttribute, int n2) throws CompileError {
        LocalVariableAttribute localVariableAttribute = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        if (localVariableAttribute == null) {
            return false;
        }
        int n3 = localVariableAttribute.tableLength();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = localVariableAttribute.index(i2);
            if (n4 >= n2) continue;
            this.gen.recordVariable(localVariableAttribute.descriptor(i2), localVariableAttribute.variableName(i2), n4, this.stable);
        }
        return true;
    }

    public int recordParams(CtClass[] ctClassArray, boolean bl2) throws CompileError {
        return this.gen.recordParams(ctClassArray, bl2, "$", "$args", "$$", this.stable);
    }

    public int recordParams(String string, CtClass[] ctClassArray, boolean bl2, int n2, boolean bl3) throws CompileError {
        return this.gen.recordParams(ctClassArray, bl3, "$", "$args", "$$", bl2, n2, string, this.stable);
    }

    public void setMaxLocals(int n2) {
        this.gen.setMaxLocals(n2);
    }

    public int recordReturnType(CtClass ctClass, boolean bl2) throws CompileError {
        this.gen.recordType(ctClass);
        return this.gen.recordReturnType(ctClass, "$r", bl2 ? resultVarName : null, this.stable);
    }

    public void recordType(CtClass ctClass) {
        this.gen.recordType(ctClass);
    }

    public int recordVariable(CtClass ctClass, String string) throws CompileError {
        return this.gen.recordVariable(ctClass, string, this.stable);
    }

    public void recordProceed(String string, String string2) throws CompileError {
        Parser parser = new Parser(new Lex(string));
        ASTree aSTree = parser.parseExpression(this.stable);
        String string3 = string2;
        Javac$1 javac$1 = new Javac$1(this, string3, aSTree);
        this.gen.setProceedHandler(javac$1, proceedName);
    }

    public void recordStaticProceed(String string, String string2) throws CompileError {
        String string3 = string;
        String string4 = string2;
        Javac$2 javac$2 = new Javac$2(this, string3, string4);
        this.gen.setProceedHandler(javac$2, proceedName);
    }

    public void recordSpecialProceed(String string, String string2, String string3, String string4) throws CompileError {
        Parser parser = new Parser(new Lex(string));
        ASTree aSTree = parser.parseExpression(this.stable);
        String string5 = string2;
        String string6 = string3;
        String string7 = string4;
        Javac$3 javac$3 = new Javac$3(this, aSTree, string5, string6, string7);
        this.gen.setProceedHandler(javac$3, proceedName);
    }

    public void recordProceed(ProceedHandler proceedHandler) {
        this.gen.setProceedHandler(proceedHandler, proceedName);
    }

    public void compileStmnt(String string) throws CompileError {
        Parser parser = new Parser(new Lex(string));
        SymbolTable symbolTable = new SymbolTable(this.stable);
        while (parser.hasMore()) {
            Stmnt stmnt = parser.parseStatement(symbolTable);
            if (stmnt == null) continue;
            stmnt.accept(this.gen);
        }
    }

    public void compileExpr(String string) throws CompileError {
        ASTree aSTree = Javac.parseExpr(string, this.stable);
        this.compileExpr(aSTree);
    }

    public static ASTree parseExpr(String string, SymbolTable symbolTable) throws CompileError {
        Parser parser = new Parser(new Lex(string));
        return parser.parseExpression(symbolTable);
    }

    public void compileExpr(ASTree aSTree) throws CompileError {
        if (aSTree != null) {
            this.gen.compileExpr(aSTree);
        }
    }
}

