/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.convert;

import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtField;
import org.zeroturnaround.bundled.javassist.Modifier;
import org.zeroturnaround.bundled.javassist.bytecode.CodeAttribute;
import org.zeroturnaround.bundled.javassist.bytecode.CodeIterator;
import org.zeroturnaround.bundled.javassist.bytecode.ConstPool;
import org.zeroturnaround.bundled.javassist.convert.TransformReadField;
import org.zeroturnaround.bundled.javassist.convert.Transformer;

public final class TransformFieldAccess
extends Transformer {
    private String newClassname;
    private String newFieldname;
    private String fieldname;
    private CtClass fieldClass;
    private boolean isPrivate;
    private int newIndex;
    private ConstPool constPool;

    public TransformFieldAccess(Transformer transformer, CtField ctField, String string, String string2) {
        super(transformer);
        this.fieldClass = ctField.getDeclaringClass();
        this.fieldname = ctField.getName();
        this.isPrivate = Modifier.isPrivate(ctField.getModifiers());
        this.newClassname = string;
        this.newFieldname = string2;
        this.constPool = null;
    }

    public void initialize(ConstPool constPool, CodeAttribute codeAttribute) {
        if (this.constPool != constPool) {
            this.newIndex = 0;
        }
    }

    public int transform(CtClass ctClass, int n2, CodeIterator codeIterator, ConstPool constPool) {
        int n3 = codeIterator.byteAt(n2);
        if (n3 == 180 || n3 == 178 || n3 == 181 || n3 == 179) {
            int n4 = codeIterator.u16bitAt(n2 + 1);
            String string = TransformReadField.isField(ctClass.getClassPool(), constPool, this.fieldClass, this.fieldname, this.isPrivate, n4);
            if (string != null) {
                if (this.newIndex == 0) {
                    int n5 = constPool.addNameAndTypeInfo(this.newFieldname, string);
                    this.newIndex = constPool.addFieldrefInfo(constPool.addClassInfo(this.newClassname), n5);
                    this.constPool = constPool;
                }
                codeIterator.write16bit(this.newIndex, n2 + 1);
            }
        }
        return n2;
    }
}

