/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.bundled.javassist.util.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.zeroturnaround.bundled.javassist.util.proxy.ProxyFactory;

public class ProxyObjectInputStream
extends ObjectInputStream {
    private ClassLoader loader = Thread.currentThread().getContextClassLoader();

    public ProxyObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
        if (this.loader == null) {
            this.loader = ClassLoader.getSystemClassLoader();
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.loader = classLoader;
        } else {
            classLoader = ClassLoader.getSystemClassLoader();
        }
    }

    protected ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
        boolean bl2 = this.readBoolean();
        if (bl2) {
            String string = (String)this.readObject();
            Class<?> clazz = this.loader.loadClass(string);
            int n2 = this.readInt();
            Class[] classArray = new Class[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                string = (String)this.readObject();
                classArray[i2] = this.loader.loadClass(string);
            }
            n2 = this.readInt();
            byte[] byArray = new byte[n2];
            this.read(byArray);
            ProxyFactory proxyFactory = new ProxyFactory();
            proxyFactory.setUseCache(true);
            proxyFactory.setUseWriteReplace(false);
            proxyFactory.setSuperclass(clazz);
            proxyFactory.setInterfaces(classArray);
            Class clazz2 = proxyFactory.createClass(byArray);
            return ObjectStreamClass.lookup(clazz2);
        }
        return super.readClassDescriptor();
    }
}

