/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel;

import com.zeroturnaround.javarebel.bn;
import com.zeroturnaround.javarebel.bp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.zeroturnaround.javarebel.DiagnosticsInfo;
import org.zeroturnaround.javarebel.DiagnosticsInfoManager;
import org.zeroturnaround.javarebel.DiagnosticsInfoManagerFactory;
import org.zeroturnaround.javarebel.DiagnosticsInfoProvider;
import org.zeroturnaround.javarebel.RequestData;
import org.zeroturnaround.javarebel.RequestInfoManagerFactory;
import org.zeroturnaround.javarebel.SQLQueryInfo;

public class SQLDiagnosticsInfoProvider
implements DiagnosticsInfoProvider {
    public static final String ID = "SqlQueries";
    static DiagnosticsInfoManager manager = DiagnosticsInfoManagerFactory.getInstance();
    static final SQLDiagnosticsInfoProvider provider = new SQLDiagnosticsInfoProvider();
    private final List queries = new ArrayList();

    public static void init() {
        if (manager.getProvider(ID, provider.getClass().getClassLoader()) == null) {
            throw new IllegalStateException("Failed to init and register SQLDiagnosticsInfoProvider");
        }
    }

    public String getId() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagnosticsInfo getDiagnosticsInfo(String[] stringArray) {
        String string = stringArray[1];
        DiagnosticsInfo diagnosticsInfo = new DiagnosticsInfo(ID);
        Iterator iterator = this.queries.iterator();
        while (iterator.hasNext()) {
            SQLQueryInfo sQLQueryInfo = (SQLQueryInfo)iterator.next();
            if (!string.equals(sQLQueryInfo.requestId)) continue;
            SQLQueryInfo sQLQueryInfo2 = sQLQueryInfo;
            synchronized (sQLQueryInfo2) {
                DiagnosticsInfo diagnosticsInfo2 = new DiagnosticsInfo("query");
                diagnosticsInfo2.addChild(new DiagnosticsInfo("id", sQLQueryInfo.getId()));
                diagnosticsInfo2.addChild(new DiagnosticsInfo("timestamp", sQLQueryInfo.timestamp));
                diagnosticsInfo2.addChild(new DiagnosticsInfo("requestId", sQLQueryInfo.requestId));
                diagnosticsInfo2.addChild(new DiagnosticsInfo("rawSql", sQLQueryInfo.rawSql));
                diagnosticsInfo2.addChild(new DiagnosticsInfo("sql", sQLQueryInfo.sql));
                diagnosticsInfo2.addChild(new DiagnosticsInfo("duration", sQLQueryInfo.duration));
                diagnosticsInfo2.addChild(new DiagnosticsInfo("stackTrace", this.getStackTrace(sQLQueryInfo.stackTrace)));
                diagnosticsInfo2.addChild(new DiagnosticsInfo("statementId", sQLQueryInfo.statementId));
                diagnosticsInfo2.addChild(new DiagnosticsInfo("driverName", sQLQueryInfo.driverName));
                diagnosticsInfo2.addChild(new DiagnosticsInfo("dataAccessFramework", sQLQueryInfo.dataAccess));
                diagnosticsInfo2.addChild(new DiagnosticsInfo("processingTime", sQLQueryInfo.processingTime));
                diagnosticsInfo2.addChild(new DiagnosticsInfo("numRowsProcessed", sQLQueryInfo.numRowsProcessed));
                diagnosticsInfo.addChild(diagnosticsInfo2);
            }
        }
        return diagnosticsInfo;
    }

    private List getStackTrace(StackTraceElement[] stackTraceElementArray) {
        ArrayList<DiagnosticsInfo> arrayList = new ArrayList<DiagnosticsInfo>();
        for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            DiagnosticsInfo diagnosticsInfo = new DiagnosticsInfo("stack");
            String string = stackTraceElement.getClassName();
            String string2 = stackTraceElement.getFileName();
            if (i2 == 0) {
                if (bn.a(string, "_$$_")) {
                    string = string.substring(0, string.indexOf("_$$_"));
                }
                if (bn.a(string2, "_$$_")) {
                    int n2 = string2.indexOf("_$$_");
                    int n3 = string2.lastIndexOf(".java");
                    string2 = string2.substring(0, n2) + string2.substring(n3);
                }
            }
            diagnosticsInfo.addChild(new DiagnosticsInfo("class", string));
            diagnosticsInfo.addChild(new DiagnosticsInfo("method", stackTraceElement.getMethodName()));
            diagnosticsInfo.addChild(new DiagnosticsInfo("line", Integer.toString(stackTraceElement.getLineNumber())));
            diagnosticsInfo.addChild(new DiagnosticsInfo("file", string2));
            arrayList.add(diagnosticsInfo);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLQueryInfo registerSqlQuery(Object object, String string, String string2, long l2, long l3, String string3, String string4) {
        SQLDiagnosticsInfoProvider sQLDiagnosticsInfoProvider = provider;
        synchronized (sQLDiagnosticsInfoProvider) {
            RequestData requestData = RequestInfoManagerFactory.getInstance().getCurrentRequest();
            String string5 = requestData != null ? requestData.getId() : null;
            SQLQueryInfo sQLQueryInfo = new SQLQueryInfo(string5, object, string, string2, l2, l3, bp.a(Thread.currentThread()), string3, string4);
            SQLDiagnosticsInfoProvider.provider.queries.add(sQLQueryInfo);
            if (SQLDiagnosticsInfoProvider.provider.queries.size() > 200) {
                SQLDiagnosticsInfoProvider.provider.queries.remove(0);
            }
            return sQLQueryInfo;
        }
    }

    private static String getId(Object object) {
        return Integer.toHexString(System.identityHashCode(object));
    }

    static {
        manager.addDiagnosticsInfoProvider(provider);
    }
}

