/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration;

import java.beans.Introspector;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.zeroturnaround.javarebel.ClassEventListener;
import org.zeroturnaround.javarebel.LoggerFactory;

public class IntegrationClassEventListener
implements ClassEventListener {
    private static final Field standardBeanInfoCache = IntegrationClassEventListener.getClassField("java.beans.StandardBeanInfo", "methodDescCache");
    private static final Object introspectorCacheKey = IntegrationClassEventListener.getStaticObject("java.beans.Introspector", "BEANINFO_CACHE");
    private static final Field appContextMap = IntegrationClassEventListener.getClassField("com.sun.beans.AppContext", "map");
    private static final Object appContextContexts = IntegrationClassEventListener.getStaticObject("com.sun.beans.AppContext", "contexts");
    private static final Field weakIdentityTable;
    private static final Field weakIdentityEntryValue;
    private static final Field weakIdentityEntryNext;
    private static final Object threadGroupContextContexts;
    private static final Method threadGroupContextClearBeanInfoCache;
    static Class class$java$lang$Class;
    static Class class$java$lang$Object;
    static Class class$java$util$Map;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClassEvent(int n2, Class clazz) {
        Object object;
        if (n2 == 0) {
            return;
        }
        Introspector.flushCaches();
        if (appContextContexts != null && weakIdentityTable != null) {
            try {
                object = introspectorCacheKey;
                synchronized (introspectorCacheKey) {
                    Object[] objectArray = (Object[])weakIdentityTable.get(appContextContexts);
                    for (int i2 = 0; i2 < objectArray.length; ++i2) {
                        Object object2 = objectArray[i2];
                        while (object2 != null) {
                            Object object3 = weakIdentityEntryValue.get(object2);
                            ((Map)appContextMap.get(object3)).clear();
                            object2 = weakIdentityEntryNext.get(object2);
                        }
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            catch (Exception exception) {
                LoggerFactory.getLogger("Introspector").info("Could not clear cache: " + exception.getMessage(), exception);
            }
        } else if (threadGroupContextContexts != null && threadGroupContextClearBeanInfoCache != null) {
            try {
                if (threadGroupContextContexts instanceof Map) {
                    object = ((Map)threadGroupContextContexts).values().iterator();
                    while (object.hasNext()) {
                        Object e2 = object.next();
                        threadGroupContextClearBeanInfoCache.invoke(e2, null);
                    }
                } else {
                    object = (Object[])weakIdentityTable.get(threadGroupContextContexts);
                    for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
                        Object object4 = object[i3];
                        while (object4 != null) {
                            Object object5 = weakIdentityEntryValue.get(object4);
                            threadGroupContextClearBeanInfoCache.invoke(object5, null);
                            object4 = weakIdentityEntryNext.get(object4);
                        }
                    }
                }
            }
            catch (Exception exception) {
                LoggerFactory.getLogger("Introspector").info("Could not clear cache: " + exception.getMessage(), exception);
            }
        }
        {
            if ((clazz.getModifiers() & 0x4000) != 0) {
                try {
                    object = (class$java$lang$Class == null ? (class$java$lang$Class = IntegrationClassEventListener.class$("java.lang.Class")) : class$java$lang$Class).getDeclaredField("enumConstantDirectory");
                    ((Field)object).setAccessible(true);
                    ((Field)object).set(clazz, null);
                    object = (class$java$lang$Class == null ? (class$java$lang$Class = IntegrationClassEventListener.class$("java.lang.Class")) : class$java$lang$Class).getDeclaredField("enumConstants");
                    ((Field)object).setAccessible(true);
                    ((Field)object).set(clazz, null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                try {
                    object = (class$java$lang$Class == null ? (class$java$lang$Class = IntegrationClassEventListener.class$("java.lang.Class")) : class$java$lang$Class).getDeclaredField("_cachedEnumConstantDirectory");
                    ((Field)object).setAccessible(true);
                    ((Field)object).set(clazz, null);
                    object = (class$java$lang$Class == null ? (class$java$lang$Class = IntegrationClassEventListener.class$("java.lang.Class")) : class$java$lang$Class).getDeclaredField("_cachedEnumConstants");
                    ((Field)object).setAccessible(true);
                    ((Field)object).set(clazz, null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            if (standardBeanInfoCache != null) {
                try {
                    object = (class$java$util$Map == null ? (class$java$util$Map = IntegrationClassEventListener.class$("java.util.Map")) : class$java$util$Map).getDeclaredMethod("remove", class$java$lang$Object == null ? (class$java$lang$Object = IntegrationClassEventListener.class$("java.lang.Object")) : class$java$lang$Object);
                    ((Method)object).invoke(standardBeanInfoCache.get(null), clazz);
                }
                catch (SecurityException securityException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
            return;
        }
    }

    public int priority() {
        return 1011000;
    }

    private static Object getStaticObject(String string, String string2) {
        Object object = null;
        try {
            Class<?> clazz = Class.forName(string);
            Field field = clazz.getDeclaredField(string2);
            field.setAccessible(true);
            object = field.get(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        LoggerFactory.getLogger("Introspector").info("Did we find " + string + "." + string2 + ": " + (object != null));
        return object;
    }

    private static Field getClassField(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string);
            Field field = clazz.getDeclaredField(string2);
            field.setAccessible(true);
            return field;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return null;
    }

    private static Method getClassMethod(String string, String string2) {
        try {
            Class<?> clazz = Class.forName(string);
            Method method = clazz.getDeclaredMethod(string2, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        Field field = IntegrationClassEventListener.getClassField("com.sun.beans.WeakIdentityMap", "table");
        Field field2 = IntegrationClassEventListener.getClassField("com.sun.beans.WeakIdentityMap$Entry", "value");
        Field field3 = IntegrationClassEventListener.getClassField("com.sun.beans.WeakIdentityMap$Entry", "next");
        if (field == null) {
            field = IntegrationClassEventListener.getClassField("java.beans.WeakIdentityMap", "table");
            field2 = IntegrationClassEventListener.getClassField("java.beans.WeakIdentityMap$Entry", "value");
            field3 = IntegrationClassEventListener.getClassField("java.beans.WeakIdentityMap$Entry", "next");
        }
        weakIdentityTable = field;
        weakIdentityEntryValue = field2;
        weakIdentityEntryNext = field3;
        threadGroupContextContexts = IntegrationClassEventListener.getStaticObject("java.beans.ThreadGroupContext", "contexts");
        threadGroupContextClearBeanInfoCache = IntegrationClassEventListener.getClassMethod("java.beans.ThreadGroupContext", "clearBeanInfoCache");
    }
}

