/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.base;

import org.zeroturnaround.javarebel.ClassBytecodeProcessor;
import org.zeroturnaround.javarebel.ClassResourceSource;
import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.Integration;
import org.zeroturnaround.javarebel.IntegrationFactory;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.Plugin;
import org.zeroturnaround.javarebel.integration.base.FindClassBaseCBP;
import org.zeroturnaround.javarebel.integration.base.glassfish.EJBClassLoaderBaseCBP;
import org.zeroturnaround.javarebel.integration.base.glassfish.FelixBundleWiringImplBaseCBP;
import org.zeroturnaround.javarebel.integration.base.glassfish.FelixContentLoaderImplCBP;
import org.zeroturnaround.javarebel.integration.base.glassfish.FelixModuleClassLoaderBaseCBP;
import org.zeroturnaround.javarebel.integration.base.glassfish.FelixModuleImplBaseCBP;
import org.zeroturnaround.javarebel.integration.base.glassfish.WebApplicationCBP;
import org.zeroturnaround.javarebel.integration.base.glassfish.WebModuleBaseCBP;
import org.zeroturnaround.javarebel.integration.base.jboss4.RepositoryClassLoaderBaseCBP;
import org.zeroturnaround.javarebel.integration.base.jboss5.BaseClassLoaderBaseCBP;
import org.zeroturnaround.javarebel.integration.base.jboss7.ConcurrentClassLoaderCBP;
import org.zeroturnaround.javarebel.integration.base.jboss7.ModuleClassLoaderBaseCBP;
import org.zeroturnaround.javarebel.integration.base.jboss7.ModuleLoaderCBP;
import org.zeroturnaround.javarebel.integration.base.jetty.EclipseJettyWebappClassLoaderCBP;
import org.zeroturnaround.javarebel.integration.base.tomcat.WebappClassLoaderBaseCBP;

public class BaseIntegrationPlugin
implements Plugin {
    public void preinit() {
        LoggerFactory.getLogger("Integration-Base").log("Started BaseIntegrationPlugin.");
        Integration integration = IntegrationFactory.getInstance();
        this.patchStandardClassLoaders(integration);
        this.patchTomcat(integration);
        this.patchGlassfish(integration);
        this.patchJetty(integration);
        this.patchJBoss(integration);
    }

    private void patchStandardClassLoaders(Integration integration) {
        String[] stringArray = new String[]{"org.apache.catalina.loader.StandardClassLoader", "org.mortbay.jetty.webapp.WebAppClassLoader", "com.evermind.naming.ContextClassLoader", "org.objectweb.jonas_lib.loader.EjbJarClassLoader", "com.sun.jnlp.JNLPClassLoader", "org.aspectj.weaver.bcel.ExtensibleURLClassLoader"};
        integration.addIntegrationProcessor(stringArray, (ClassBytecodeProcessor)new FindClassBaseCBP());
    }

    private void patchTomcat(Integration integration) {
        integration.addIntegrationProcessor(new String[]{"org.apache.catalina.loader.WebappClassLoader", "org.glassfish.web.loader.WebappClassLoader", "de.hybris.tomcat.HybrisWebappClassLoader60"}, (ClassBytecodeProcessor)new WebappClassLoaderBaseCBP());
    }

    private void patchGlassfish(Integration integration) {
        integration.addIntegrationProcessor(new String[]{"com.sun.enterprise.loader.EJBClassLoader", "com.sun.enterprise.loader.ASURLClassLoader"}, (ClassBytecodeProcessor)new EJBClassLoaderBaseCBP());
        integration.addIntegrationProcessor("com.sun.enterprise.web.WebApplication", (ClassBytecodeProcessor)new WebApplicationCBP());
        integration.addIntegrationProcessor("org.apache.felix.framework.searchpolicy.ContentLoaderImpl", (ClassBytecodeProcessor)new FelixContentLoaderImplCBP());
        integration.addIntegrationProcessor(new String[]{"org.apache.felix.framework.searchpolicy.ModuleImpl", "org.apache.felix.framework.ModuleImpl"}, (ClassBytecodeProcessor)new FelixModuleImplBaseCBP());
        integration.addIntegrationProcessor(new String[]{"org.apache.felix.framework.searchpolicy.ModuleImpl$ModuleClassLoader", "org.apache.felix.framework.ModuleImpl$ModuleClassLoader"}, (ClassBytecodeProcessor)new FelixModuleClassLoaderBaseCBP());
        integration.addIntegrationProcessor("org.apache.felix.framework.BundleWiringImpl", (ClassBytecodeProcessor)new FelixBundleWiringImplBaseCBP());
        integration.addIntegrationProcessor("com.sun.enterprise.web.WebModule", (ClassBytecodeProcessor)new WebModuleBaseCBP());
    }

    private void patchJetty(Integration integration) {
        integration.addIntegrationProcessor("org.eclipse.jetty.webapp.WebAppClassLoader", (ClassBytecodeProcessor)new EclipseJettyWebappClassLoaderCBP());
    }

    private void patchJBoss(Integration integration) {
        integration.addIntegrationProcessor("org.jboss.mx.loading.RepositoryClassLoader", (ClassBytecodeProcessor)new RepositoryClassLoaderBaseCBP());
        integration.addIntegrationProcessor("org.jboss.classloader.spi.base.BaseClassLoader", (ClassBytecodeProcessor)new BaseClassLoaderBaseCBP());
        integration.addIntegrationProcessor("org.jboss.modules.ConcurrentClassLoader", (ClassBytecodeProcessor)new ConcurrentClassLoaderCBP());
        integration.addIntegrationProcessor("org.jboss.modules.ModuleClassLoader", (ClassBytecodeProcessor)new ModuleClassLoaderBaseCBP());
        integration.addIntegrationProcessor("org.jboss.modules.ModuleLoader", (ClassBytecodeProcessor)new ModuleLoaderCBP());
        ConfigurationFactory.getInstance().addExcludeFilter("org.jboss.mx.loading.HeirarchicalLoaderRepository3$CacheClassLoader");
    }

    public boolean checkDependencies(ClassLoader classLoader, ClassResourceSource classResourceSource) {
        return false;
    }

    public String getDescription() {
        return null;
    }

    public String getId() {
        return null;
    }

    public String getName() {
        return null;
    }

    public String getAuthor() {
        return null;
    }

    public String getWebsite() {
        return null;
    }

    public String getSupportedVersions() {
        return null;
    }

    public String getTestedVersions() {
        return null;
    }
}

