/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.streambase;

import org.zeroturnaround.bundled.javassist.CannotCompileException;
import org.zeroturnaround.bundled.javassist.ClassPool;
import org.zeroturnaround.bundled.javassist.CtClass;
import org.zeroturnaround.bundled.javassist.CtConstructor;
import org.zeroturnaround.bundled.javassist.CtNewMethod;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.integration.support.JavassistClassBytecodeProcessor;

public class StreamBaseJarClassLoaderCBP
extends JavassistClassBytecodeProcessor {
    static Class class$java$lang$String;

    public void process(ClassPool classPool, ClassLoader classLoader, CtClass ctClass) throws Exception {
        classPool.importPackage("org.zeroturnaround.javarebel");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.generic");
        this.initializeClassLoader(ctClass);
        this.reinitializeClassLoader(classPool, ctClass);
        this.baseIntegration(classPool, ctClass);
        this.resourceStreamProviding(classPool, ctClass);
    }

    private void initializeClassLoader(CtClass ctClass) throws CannotCompileException {
        CtConstructor[] ctConstructorArray = ctClass.getConstructors();
        for (int i2 = 0; i2 < ctConstructorArray.length; ++i2) {
            ctConstructorArray[i2].insertAfter("{  IntegrationFactory.getInstance().registerClassLoader($0, new RestrictedClassResourceSource($0));}");
        }
    }

    private void reinitializeClassLoader(ClassPool classPool, CtClass ctClass) throws CannotCompileException {
        classPool.importPackage("org.zeroturnaround.javarebel");
        try {
            ctClass.getDeclaredMethod("addJar").insertAfter("{  IntegrationFactory.getInstance().reinitializeClassLoader($0);}");
        }
        catch (NotFoundException notFoundException) {
            LoggerFactory.getInstance().error(notFoundException);
        }
        try {
            ctClass.getDeclaredMethod("removeJar").insertAfter("{  IntegrationFactory.getInstance().reinitializeClassLoader($0);}");
        }
        catch (NotFoundException notFoundException) {
            LoggerFactory.getInstance().error(notFoundException);
        }
    }

    private void baseIntegration(ClassPool classPool, CtClass ctClass) throws NotFoundException, CannotCompileException {
        classPool.importPackage("org.zeroturnaround.javarebel");
        ctClass.getMethod("findClass", "(Ljava/lang/String;)Ljava/lang/Class;").insertBefore("{ synchronized ($0) {    Class result =      findLoadedClass($1);    if (result != null)      return result;    result =       IntegrationFactory.getInstance().findReloadableClass($0, $1);    if (result != null)      return result;}}");
        try {
            ctClass.getDeclaredMethod("findResource", classPool.get(new String[]{(class$java$lang$String == null ? (class$java$lang$String = StreamBaseJarClassLoaderCBP.class$("java.lang.String")) : class$java$lang$String).getName()})).insertBefore("{  Integration integration = IntegrationFactory.getInstance();  if (integration.isResourceReplaced($0, $1))    return integration.findResource($0, $1);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        try {
            ctClass.getDeclaredMethod("findResources", classPool.get(new String[]{(class$java$lang$String == null ? (class$java$lang$String = StreamBaseJarClassLoaderCBP.class$("java.lang.String")) : class$java$lang$String).getName()})).insertBefore("{  Integration integration = IntegrationFactory.getInstance();  if (integration.isResourceReplaced($0, $1))    return integration.findResources($0, $1);}");
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
    }

    private void resourceStreamProviding(ClassPool classPool, CtClass ctClass) throws CannotCompileException {
        classPool.importPackage("java.io");
        classPool.importPackage("java.net");
        classPool.importPackage("java.util");
        classPool.importPackage("java.util.jar");
        classPool.importPackage("org.zeroturnaround.javarebel");
        classPool.importPackage("org.zeroturnaround.javarebel.integration.streambase");
        classPool.importPackage("com.streambase.sb.util");
        boolean bl2 = false;
        try {
            ctClass.getDeclaredMethod("findResource");
        }
        catch (NotFoundException notFoundException) {
            bl2 = true;
        }
        if (bl2) {
            try {
                ctClass.removeMethod(ctClass.getDeclaredMethod("getResourceAsStream"));
            }
            catch (NotFoundException notFoundException) {
                LoggerFactory.getInstance().error(notFoundException);
            }
            ctClass.addMethod(CtNewMethod.make("protected URL findResource(String name) {  Integration integration = IntegrationFactory.getInstance();  if (integration.isResourceReplaced($0, $1))    return integration.findResource($0, $1);  Msg.debug2(\"find findResource: {0}\", new Object[] { name });  Iterator i = this.jars.values().iterator();  if (i.hasNext()) {    JarFile jf = (JarFile)i.next();    JarEntry je = jf.getJarEntry(name);    if (je != null) {      return JarUtil.toURL(jf, je);    }  }  return null;}", ctClass));
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

