/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.support;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.zeroturnaround.bundled.javassist.ClassPath;
import org.zeroturnaround.bundled.javassist.NotFoundException;
import org.zeroturnaround.javarebel.AgentIntegration;
import org.zeroturnaround.javarebel.AgentIntegrationFactory;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;

public final class PublicAgentClassPath
implements ClassPath {
    private static final Logger log = LoggerFactory.getInstance();
    private static final AgentIntegration agent = AgentIntegrationFactory.getInstance();
    private static final ClassPath instance = new PublicAgentClassPath();

    public static ClassPath getInstance() {
        return instance;
    }

    private PublicAgentClassPath() {
    }

    public URL find(String string) {
        byte[] byArray = agent.getPublicClassBytes(string);
        if (byArray != null) {
            try {
                return new URL("file://agent/" + string);
            }
            catch (MalformedURLException malformedURLException) {
                log.error(malformedURLException);
            }
        }
        return null;
    }

    public InputStream openClassfile(String string) throws NotFoundException {
        byte[] byArray = agent.getPublicClassBytes(string);
        if (byArray != null) {
            return new ByteArrayInputStream(byArray);
        }
        throw new NotFoundException(string);
    }

    public void close() {
    }
}

