/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;

public class LogMonitorHelper {
    private static Logger logger = LoggerFactory.getLogger("LogMonitor");
    private static String monitorRegex = null;

    public static boolean shouldMonitorLogMethod() {
        return monitorRegex != null;
    }

    public static void monitorLogMethod(Object object) {
        String string;
        if (object != null && (string = object.toString()).matches(monitorRegex)) {
            String string2 = "Output string '" + string + "' matched regex '" + monitorRegex + "', call stack: \n";
            StringBuffer stringBuffer = new StringBuffer(string2);
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            for (int i2 = 2; i2 < stackTraceElementArray.length; ++i2) {
                stringBuffer.append("\t").append(stackTraceElementArray[i2]).append("\n");
            }
            logger.info(stringBuffer.toString());
        }
    }

    static {
        String string = ConfigurationFactory.getInstance().getProperty("rebel.log.monitor.regex");
        if (string != null) {
            try {
                string = string.replaceAll("^\"|^'|\"$|'$", "");
                Pattern.compile(string);
                monitorRegex = string;
                logger.info("Setup log monitor with regex pattern '{}'", monitorRegex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                logger.info("The supplied regex pattern '{}' was invalid", string);
            }
        }
    }
}

