/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.integration.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.ResourceSource;
import org.zeroturnaround.javarebel.support.FileResource;
import org.zeroturnaround.javarebel.support.ResourceUtils;
import org.zeroturnaround.javarebel.support.URLResource;

public class ResourceUtil {
    private static final Method FIND_RESOURCE_METHOD;
    private static final Method FIND_RESOURCES_METHOD;
    private static final String DOT = ".";
    private static final String DOT_DOT = "..";
    private static final String SLASH_DOT = "/.";
    private static final String SLASH_DOT_SLASH = "/./";
    static Class class$java$lang$ClassLoader;
    static Class class$java$lang$String;

    private static Method getClassLoaderMethod(String string, Class[] classArray) {
        Method method = null;
        try {
            Class<?> clazz = class$java$lang$ClassLoader;
            if (clazz == null) {
                clazz = class$java$lang$ClassLoader = new ClassLoader[0].getClass().getComponentType();
            }
            method = clazz.getDeclaredMethod(string, classArray);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LoggerFactory.getLogger("Util").errorEcho(noSuchMethodException);
        }
        return method;
    }

    public static URL findResource(ClassLoader classLoader, String string) {
        URL uRL;
        if (classLoader instanceof URLClassLoader) {
            uRL = ((URLClassLoader)classLoader).findResource(string);
        } else {
            try {
                uRL = (URL)FIND_RESOURCE_METHOD.invoke((Object)classLoader, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException.getTargetException());
            }
        }
        return uRL;
    }

    public static URL[] findResources(ClassLoader classLoader, String string) {
        Enumeration enumeration;
        if (classLoader instanceof URLClassLoader) {
            try {
                enumeration = ((URLClassLoader)classLoader).findResources(string);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
        try {
            enumeration = (Enumeration)FIND_RESOURCES_METHOD.invoke((Object)classLoader, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new RuntimeException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException(invocationTargetException.getTargetException());
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        return ResourceUtil.toURLs(enumeration);
    }

    public static URL[] findResources(URLClassLoader uRLClassLoader, String string) {
        Enumeration<URL> enumeration;
        try {
            enumeration = uRLClassLoader.findResources(string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (enumeration == null || !enumeration.hasMoreElements()) {
            return null;
        }
        return ResourceUtil.toURLs(enumeration);
    }

    public static URL[] toURLs(Enumeration enumeration) {
        if (enumeration == null) {
            return null;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        while (enumeration.hasMoreElements()) {
            arrayList.add((URL)enumeration.nextElement());
        }
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public static Enumeration toEnumeration(URL[] uRLArray) {
        return new Vector<URL>(Arrays.asList(uRLArray)).elements();
    }

    public static URL[] concat(URL[] uRLArray, URL[] uRLArray2) {
        if (uRLArray == null) {
            return uRLArray2;
        }
        if (uRLArray2 == null) {
            return uRLArray;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        arrayList.addAll(Arrays.asList(uRLArray));
        arrayList.addAll(Arrays.asList(uRLArray2));
        return arrayList.toArray(new URL[arrayList.size()]);
    }

    public static String concatClassPath(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + File.pathSeparator + string2;
    }

    public static String toClassPath(URL[] uRLArray) {
        if (uRLArray == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            URL uRL = uRLArray[i2];
            File file = ResourceUtils.getFile(uRL);
            stringBuffer.append(file.getPath());
            if (i2 >= uRLArray.length - 1) continue;
            stringBuffer.append(File.pathSeparator);
        }
        return stringBuffer.toString();
    }

    public static Resource getClassResource(ResourceSource resourceSource, String string) {
        return resourceSource.getLocalResource(string.replace('.', '/') + ".class");
    }

    public static Resource[] asArray(Resource resource) {
        if (resource == null) {
            return null;
        }
        return new Resource[]{resource};
    }

    public static Resource asResource(URL uRL) {
        if (uRL == null) {
            return null;
        }
        if (ResourceUtils.isFileURL(uRL)) {
            return new FileResource(uRL);
        }
        return new URLResource(uRL);
    }

    public static Resource[] asResources(URL[] uRLArray) {
        if (uRLArray == null) {
            return null;
        }
        Resource[] resourceArray = new Resource[uRLArray.length];
        for (int i2 = 0; i2 < uRLArray.length; ++i2) {
            resourceArray[i2] = ResourceUtil.asResource(uRLArray[i2]);
        }
        return resourceArray;
    }

    public static Resource[] asResources(Enumeration enumeration) {
        return ResourceUtil.asResources(ResourceUtil.toURLs(enumeration));
    }

    public static Resource[] asResources(List list) {
        if (list == null) {
            return null;
        }
        Resource[] resourceArray = new Resource[list.size()];
        int n2 = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            URL uRL = (URL)iterator.next();
            resourceArray[n2++] = ResourceUtil.asResource(uRL);
        }
        return resourceArray;
    }

    public static InputStream asRawInputStream(URL uRL) {
        try {
            if (uRL != null) {
                return uRL.openStream();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static InputStream asInputStream(URL uRL) {
        if (uRL == null) {
            return null;
        }
        byte[] byArray = ResourceUtil.asResource(uRL).getBytes();
        if (byArray == null) {
            return null;
        }
        return new ByteArrayInputStream(byArray);
    }

    public static URL makeURL(File file) throws MalformedURLException {
        if (file == null) {
            return null;
        }
        return file.toURI().toURL();
    }

    public static URL makeURL(File file, String string) throws MalformedURLException {
        if (file == null) {
            return null;
        }
        if (string == null) {
            return ResourceUtil.makeURL(file);
        }
        return new URL("jar:" + file.toURI().toURL() + "!/" + string);
    }

    public static File getFileFromPathOrURL(String string) throws MalformedURLException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.exists()) {
            return file;
        }
        return ResourceUtils.getFile(new URL(string));
    }

    public static File getFileFromURL(String string) throws MalformedURLException {
        if (string == null) {
            return null;
        }
        return ResourceUtils.getFile(new URL(string));
    }

    public static File getFileFromURL(URL uRL) {
        if (uRL == null) {
            return null;
        }
        return ResourceUtils.getFile(uRL);
    }

    public static String getFaceletPath(URL uRL, String string, String string2) {
        if (string2 == null || !string2.startsWith("/") && !string2.startsWith(File.separator)) {
            return string;
        }
        if (string == null || string.startsWith("/") || string.startsWith(File.separator)) {
            return string;
        }
        try {
            if (string.equals(new URL(uRL, string).toString())) {
                return string;
            }
            if (new URL(string).toString().equals(new URL(uRL, string).toString())) {
                return string;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        String string3 = ResourceUtil.resolveRelativePath(ResourceUtil.combine(string2, string));
        if (LoggerFactory.getInstance().isInfoEnabled()) {
            LoggerFactory.getLogger("FaceltResource").info("Getting facelet path src='" + uRL + "', path='" + string + "', originalPath='" + string2 + "' -> '" + string3 + "'.");
        }
        return string3;
    }

    public static String combine(String string, String string2) {
        while (string.length() > 1 && (string.endsWith("/") || string.endsWith(File.separator))) {
            string = string.substring(0, string.length() - 1);
        }
        int n2 = Math.max(string.lastIndexOf(47), string.lastIndexOf(File.separatorChar));
        return string.substring(0, n2 + 1) + string2;
    }

    public static String resolveRelativePath(String string) {
        CharSequence charSequence;
        String string2 = string.replace(File.separatorChar, '/');
        if (!string2.startsWith(DOT) && string2.indexOf(DOT_DOT) == -1 && string2.indexOf(SLASH_DOT_SLASH) == -1 && !string2.endsWith(SLASH_DOT)) {
            return string;
        }
        boolean bl2 = string2.endsWith("/");
        if (bl2) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n2 = 0;
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (DOT_DOT.equals(charSequence)) {
                if (arrayList.isEmpty()) {
                    ++n2;
                    continue;
                }
                arrayList.remove(arrayList.size() - 1);
                continue;
            }
            if (DOT.equals(charSequence)) continue;
            arrayList.add(charSequence);
        }
        charSequence = new StringBuffer();
        boolean bl3 = string2.startsWith("/");
        for (int i2 = 0; i2 < n2; ++i2) {
            if (bl3 || ((StringBuffer)charSequence).length() > 0) {
                ((StringBuffer)charSequence).append('/');
            }
            ((StringBuffer)charSequence).append(DOT_DOT);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            if (bl3 || ((StringBuffer)charSequence).length() > 0) {
                ((StringBuffer)charSequence).append('/');
            }
            ((StringBuffer)charSequence).append((String)iterator.next());
        }
        if (bl2 && !arrayList.isEmpty()) {
            ((StringBuffer)charSequence).append('/');
        }
        LoggerFactory.getLogger("Util").info("Converted '{}' into '{}'", string, charSequence);
        return ((StringBuffer)charSequence).toString();
    }

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$java$lang$String;
        if (clazz == null) {
            clazz = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        classArray[0] = clazz;
        FIND_RESOURCE_METHOD = ResourceUtil.getClassLoaderMethod("findResource", classArray);
        Class[] classArray2 = new Class[1];
        Class<?> clazz2 = class$java$lang$String;
        if (clazz2 == null) {
            clazz2 = class$java$lang$String = new String[0].getClass().getComponentType();
        }
        classArray2[0] = clazz2;
        FIND_RESOURCES_METHOD = ResourceUtil.getClassLoaderMethod("findResources", classArray2);
    }
}

