/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.zeroturnaround.javarebel.Resource;
import org.zeroturnaround.javarebel.support.ResourceUtils;

public class FileResource
implements Resource {
    private final File file;
    private final URL url;

    public FileResource(File file) {
        this.file = file;
        try {
            this.url = file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException(malformedURLException);
        }
    }

    public FileResource(URL uRL) {
        this.url = uRL;
        this.file = ResourceUtils.getFile(uRL);
    }

    public File getFile() {
        return this.file;
    }

    public byte[] getBytes() {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException(fileNotFoundException);
        }
        try {
            int n2;
            long l2 = this.file.length();
            if (l2 > Integer.MAX_VALUE) {
                throw new IllegalStateException("File '" + this.file.getAbsolutePath() + "' is too large.");
            }
            byte[] byArray = new byte[(int)l2];
            int n3 = 0;
            for (n2 = 0; n2 < byArray.length && (n3 = ((InputStream)fileInputStream).read(byArray, n2, byArray.length - n2)) >= 0; n2 += n3) {
            }
            if (n2 < byArray.length) {
                throw new IOException("Could not completely read file " + this.file.getName());
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public long lastModified() {
        return this.file.lastModified();
    }

    public String toString() {
        return this.url.toString();
    }

    public URL toURL() {
        return this.url;
    }
}

