/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.jaxb.endorsed.proxy;

import com.sun.xml.bind.v2.runtime.JAXBContextImpl;
import com.sun.xml.bind.v2.runtime.JaxBeanInfo;
import com.sun.xml.bind.v2.runtime.MarshallerImpl;
import com.sun.xml.bind.v2.runtime.unmarshaller.UnmarshallerImpl;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.zeroturnaround.bundled.javassist.util.proxy.MethodHandler;
import org.zeroturnaround.javarebel.ClassEventListener;
import org.zeroturnaround.javarebel.ConfigurationFactory;
import org.zeroturnaround.javarebel.Logger;
import org.zeroturnaround.javarebel.LoggerFactory;
import org.zeroturnaround.javarebel.ReloaderFactory;
import org.zeroturnaround.javarebel.integration.util.MiscUtil;
import org.zeroturnaround.jrebel.jaxb.endorsed.proxy.JaxbContextFactory;

public class JaxbContextProxyHandler
implements MethodHandler,
ClassEventListener {
    private static final Logger log = LoggerFactory.getLogger("JAXB");
    private JaxbContextFactory contextFactory;
    private JAXBContextImpl proxy;
    private JAXBContextImpl context;
    private List<Field> updatableFields;
    private Field typeMapField;
    private volatile boolean reloadHappened;
    private volatile long lastReloadCheck = System.currentTimeMillis();
    private static final int reloadCheckInterval = ConfigurationFactory.getInstance().getCheckInterval();

    public JaxbContextProxyHandler(JaxbContextFactory jaxbContextFactory, JAXBContextImpl jAXBContextImpl) throws Exception {
        this.contextFactory = jaxbContextFactory;
        this.proxy = jAXBContextImpl;
        this.context = this.buildContext();
        ReloaderFactory.getInstance().addClassReloadListener(new WeakReference<JaxbContextProxyHandler>(this));
        if (log.isTraceEnabled()) {
            log.trace("Create context '" + MiscUtil.identityToString(this) + "'");
        }
    }

    private synchronized JAXBContextImpl findContext(Method method) throws Exception {
        this.flushClassReloads();
        if (this.reloadHappened) {
            log.info("Rebuilding context '" + MiscUtil.identityToString(this) + "'");
            this.reloadHappened = false;
            this.context = this.buildContext();
        }
        return this.context;
    }

    private JAXBContextImpl buildContext() throws Exception {
        JAXBContextImpl jAXBContextImpl = this.contextFactory.buildContext();
        this.updateFields(jAXBContextImpl);
        return jAXBContextImpl;
    }

    private void updateFields(JAXBContextImpl jAXBContextImpl) throws Exception {
        if (this.updatableFields == null) {
            Field[] fieldArray = JAXBContextImpl.class.getDeclaredFields();
            this.updatableFields = new ArrayList<Field>(fieldArray.length);
            for (Object object : fieldArray) {
                if (Modifier.isStatic(((Field)object).getModifiers())) continue;
                ((Field)object).setAccessible(true);
                this.updatableFields.add((Field)object);
            }
        }
        for (Field field : this.updatableFields) {
            field.set(this.proxy, field.get(jAXBContextImpl));
        }
    }

    private void flushClassReloads() throws Exception {
        if (this.lastReloadCheck + (long)reloadCheckInterval < System.currentTimeMillis()) {
            log.trace("Buffer has expired, gonna check JAXB classes for changes");
            if (this.typeMapField == null) {
                this.typeMapField = JAXBContextImpl.class.getDeclaredField("typeMap");
                this.typeMapField.setAccessible(true);
            }
            HashMap hashMap = (HashMap)this.typeMapField.get(this.context);
            for (JaxBeanInfo jaxBeanInfo : hashMap.values()) {
                Class clazz = jaxBeanInfo.jaxbType;
                ReloaderFactory.getInstance().checkAndReload(clazz);
            }
            this.lastReloadCheck = System.currentTimeMillis();
        }
    }

    public Object invoke(Object object, Method method, Method method2, Object[] objectArray) throws Throwable {
        boolean bl2;
        if (log.isTraceEnabled()) {
            log.trace("Invoking method on proxy '" + MiscUtil.identityToString(this) + "'");
        }
        JAXBContextImpl jAXBContextImpl = this.findContext(method);
        if (method.getName().equals("createMarshaller")) {
            return this.createMarshaller();
        }
        if (method.getName().equals("createUnmarshaller") && (bl2 = true)) {
            return this.createUnmarshaller();
        }
        try {
            return method.invoke((Object)jAXBContextImpl, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getTargetException();
        }
    }

    public MarshallerImpl createMarshaller() {
        return new MarshallerImpl(this.proxy, null);
    }

    public UnmarshallerImpl createUnmarshaller() {
        return new UnmarshallerImpl(this.proxy, null);
    }

    public void onClassEvent(int n2, Class clazz) {
        if (log.isTraceEnabled()) {
            log.trace("Marked context dirty '" + MiscUtil.identityToString(this) + "'");
        }
        this.reloadHappened = true;
    }

    public int priority() {
        return 0;
    }
}

