/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.jrebel.conf.bus.plugin;

import com.zeroturnaround.jrebel.conf.bus.plugin.PluginCache;
import com.zeroturnaround.jrebel.conf.bus.plugin.PluginInfo;
import com.zeroturnaround.jrebel.conf.bus.plugin.PluginUtil;
import java.io.File;
import java.util.Collection;

public class Main {
    private static final String OUT_FILE = "outFile";

    public static void main(String[] args) {
        if (args.length >= 2 && "-generate-plugininfo-cache".equals(args[0])) {
            Main.handleGeneratePluginInfoCache(args[1]);
        }
        System.out.println("Invalid arguments. Use -generate-plugininfo-cache /path/to/jrebel.jar");
        System.exit(1);
    }

    private static void handleGeneratePluginInfoCache(String jrebelJarPath) {
        try {
            File rebelJar = new File(jrebelJarPath);
            Collection<PluginInfo> infos = PluginUtil.readAllInfos(rebelJar);
            if (System.getProperty(OUT_FILE) != null && ("System.out".equalsIgnoreCase(System.getProperty(OUT_FILE)) || "sysout".equalsIgnoreCase(System.getProperty(OUT_FILE)))) {
                PluginCache.storeAllInfos(infos);
            } else {
                File pluginInfoFile = new File(rebelJar.getParentFile(), "jrebel.plugininfo");
                PluginCache.storeAllInfos(infos, pluginInfoFile);
            }
            System.exit(0);
        }
        catch (Throwable t) {
            System.out.println("Error generating plug-in info cache");
            t.printStackTrace();
            System.exit(2);
        }
    }
}

