/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.jrebel.conf.bus.plugin;

import com.zeroturnaround.jrebel.conf.bus.plugin.PluginCategory;
import com.zeroturnaround.jrebel.conf.bus.plugin.PluginInfo;
import com.zeroturnaround.jrebel.conf.bus.plugin.PluginInfoImpl;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.zeroturnaround.jrebel.client.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginCache {
    public static final String PLUGININFO_FILE = "jrebel.plugininfo";
    private static final String EMBEDDED_PLUGININFO_PATH = "plugins/jrebel.plugininfo";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Collection<PluginInfo> loadAllInfos(File jrebelJar) {
        FileInputStream in;
        block19: {
            Collection<PluginInfo> collection;
            Collection<PluginInfo> cache;
            ZipFile zipFile = null;
            try {
                InputStream in2;
                zipFile = new ZipFile(jrebelJar);
                ZipEntry entry = zipFile.getEntry(EMBEDDED_PLUGININFO_PATH);
                if (entry != null && (cache = PluginCache.readCachedObjectFromStream(in2 = zipFile.getInputStream(entry))) != null) {
                    Collection<PluginInfo> collection2 = cache;
                    return collection2;
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    zipFile.close();
                }
                catch (Exception ignore) {}
            }
            in = null;
            try {
                File plugininfoFile = new File(jrebelJar.getParent(), PLUGININFO_FILE);
                if (!plugininfoFile.exists() || (cache = PluginCache.readCachedObjectFromStream(in = new FileInputStream(plugininfoFile))) == null) break block19;
                collection = cache;
            }
            catch (Exception exception) {
                IOUtil.silentClosing(in);
                catch (Throwable throwable) {
                    IOUtil.silentClosing(in);
                    throw throwable;
                }
            }
            IOUtil.silentClosing(in);
            return collection;
        }
        IOUtil.silentClosing(in);
        return null;
    }

    private static Collection<PluginInfo> readCachedObjectFromStream(InputStream inStream) throws IOException, ClassNotFoundException {
        Object obj = new ObjectInputStream(new BufferedInputStream(inStream)).readObject();
        return (Collection)obj;
    }

    public static void storeAllInfos(Collection<PluginInfo> infos) {
        infos.add(PluginCache.freemarker());
        infos.add(PluginCache.mentawai());
        infos.add(PluginCache.vaadin());
        Collections.sort((List)infos, new Comparator<PluginInfo>(){

            @Override
            public int compare(PluginInfo o1, PluginInfo o2) {
                return o1.getName() == null ? -1 : (o2.getName() == null ? 1 : o1.getName().compareToIgnoreCase(o2.getName()));
            }
        });
        for (PluginInfo pluginInfo : infos) {
            if (pluginInfo.getName() == null || pluginInfo.getDescription() == null || pluginInfo.isCorePlugin() || "server".equals(pluginInfo.getCategory().getId())) continue;
            PluginCache.printPluginInfo(pluginInfo);
        }
    }

    private static PluginInfo freemarker() {
        PluginInfoImpl pluginInfo = new PluginInfoImpl();
        pluginInfo.setName("Freemarker");
        pluginInfo.setId("<i>(integrated)</i>");
        pluginInfo.setDescription("<li>Reloads BeanWrapper. Remedies the flaws of FreeMarker\u2019s own JRebel integration.</li>");
        pluginInfo.setTestedVersions("2.3.16");
        pluginInfo.setSupportedVersions("2.3.7+");
        pluginInfo.setCategory(PluginCategory.FRAMEWORK);
        return pluginInfo;
    }

    private static PluginInfo mentawai() {
        PluginInfoImpl pluginInfo = new PluginInfoImpl();
        pluginInfo.setName("Mentawai");
        pluginInfo.setId("<i>(native)</i>");
        pluginInfo.setDescription("<li>Mentawai supports integration with JRebel <a href=\"http://www.mentaframework.org/api/org/mentawai/core/ApplicationManager.html#setReloadable(boolean)\">natively</a>.</li>");
        pluginInfo.setCategory(PluginCategory.FRAMEWORK);
        return pluginInfo;
    }

    private static PluginInfo vaadin() {
        PluginInfoImpl pluginInfo = new PluginInfoImpl();
        pluginInfo.setName("Vaadin");
        pluginInfo.setId("<i>(native)</i>");
        pluginInfo.setDescription("<li>JRebel works out of the box with Vaadin framework. Read more <a href=\"http://zeroturnaround.com/blog/jrebel-4-6-released-jrebel-for-vaadin-announced/\">here</a>.</li>");
        pluginInfo.setTestedVersions("6.7, 7");
        pluginInfo.setSupportedVersions("6.7.x, 7.x");
        pluginInfo.setCategory(PluginCategory.FRAMEWORK);
        return pluginInfo;
    }

    private static void printPluginInfo(PluginInfo pluginInfo) {
        System.out.println("<tr>");
        System.out.println("  <td><label class=\"fw\">" + PluginCache.stripPluginFromName(pluginInfo.getName()) + "</label></td>");
        System.out.println("  <td><div>" + pluginInfo.getId() + "</div></td>");
        System.out.println("  <td id=\"feature_cell\">");
        System.out.println("    <ul>");
        System.out.println("      " + pluginInfo.getDescription());
        System.out.println("    </ul>");
        System.out.println("  </td>");
        System.out.println("  <td>" + PluginCache.trim(pluginInfo.getTestedVersions()) + "</td>");
        System.out.println("  <td>" + PluginCache.trim(pluginInfo.getSupportedVersions()) + "</td>");
        System.out.println("</tr>");
    }

    private static String trim(String value) {
        return value != null ? value.trim() : "";
    }

    private static String stripPluginFromName(String name) {
        if (name.endsWith(" plugin") || name.endsWith(" Plugin")) {
            return name.substring(0, name.length() - 7);
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void storeAllInfos(Collection<PluginInfo> infos, File outputFile) {
        ObjectOutputStream out = null;
        try {
            out = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            out.writeObject(infos);
        }
        catch (Exception exception) {
            IOUtil.silentClosing(out);
            catch (Throwable throwable) {
                IOUtil.silentClosing(out);
                throw throwable;
            }
        }
        IOUtil.silentClosing(out);
    }
}

