/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.jrebel.conf.bus.plugin;

import com.zeroturnaround.jrebel.conf.bus.Item;
import com.zeroturnaround.jrebel.conf.bus.plugin.PluginCategory;
import com.zeroturnaround.jrebel.conf.bus.plugin.PluginInfo;
import com.zeroturnaround.jrebel.conf.bus.plugin.PluginInfoImpl;
import com.zeroturnaround.jrebel.conf.bus.plugin.ZipClassLoader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.zeroturnaround.javarebel.Plugin;
import org.zeroturnaround.jrebel.client.util.IOUtil;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginUtil {
    private static final String MANIFEST_ATTRIBUTE_PLUGIN = "JavaRebel-Plugin";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties readPluginProperties(File rebelJar) {
        Properties result;
        if (rebelJar == null) {
            throw new IllegalArgumentException("jrebel.jar must be provided");
        }
        byte[] pluginPropertiesBytes = ZipUtil.unpackEntry(rebelJar, "plugins/plugin.properties");
        if (pluginPropertiesBytes == null) {
            return new Properties();
        }
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(pluginPropertiesBytes);
            result = PluginUtil.loadProperties(inStream);
        }
        catch (Throwable throwable) {
            IOUtil.silentClosing(inStream);
            throw throwable;
        }
        IOUtil.silentClosing(inStream);
        return result;
    }

    public static Collection<PluginInfo> readAllInfos(File rebelJar) {
        if (rebelJar == null) {
            throw new IllegalArgumentException("jrebel.jar must be provided");
        }
        final ArrayList<PluginInfo> result = new ArrayList<PluginInfo>();
        final Properties[] props = new Properties[1];
        ZipUtil.iterate(rebelJar, new ZipEntryCallback(){

            public void process(InputStream in, ZipEntry entry) throws IOException {
                String name = entry.getName();
                if (name.startsWith("plugins/")) {
                    if ("plugins/plugin.properties".equals(name)) {
                        props[0] = PluginUtil.loadProperties(in);
                    } else if (name.endsWith(".jar")) {
                        String jarName = name.substring("plugins/".length());
                        try {
                            PluginInfo info = PluginUtil.readInfo(in, jarName);
                            if (info != null) {
                                result.add(info);
                            }
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        PluginUtil.postProcess(result, props[0]);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isJRebelPlugin(File file) throws Exception {
        if (file == null || !file.isFile() || !file.canRead()) {
            return false;
        }
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            PluginInfo info = PluginUtil.readInfo(in, file.getName());
        }
        catch (IllegalArgumentException e) {
            boolean bl = false;
            return bl;
        }
        catch (Throwable t) {
            boolean bl;
            block18: {
                bl = false;
                if (in == null) break block18;
                try {
                    in.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {}
            }
        }
        return true;
    }

    public static PluginInfo readInfo(InputStream in, String jarName) {
        Object instance;
        Class klass;
        ZipClassLoader cl = new ZipClassLoader(in, Plugin.class.getClassLoader());
        InputStream manifest = cl.findResourceAsStream("META-INF/MANIFEST.MF");
        if (manifest == null) {
            throw new IllegalArgumentException("Could not find manifest");
        }
        String pluginClassName = PluginUtil.getPluginClassNameFromManifest(manifest);
        try {
            klass = cl.findClass(pluginClassName);
        }
        catch (UnsupportedClassVersionError e) {
            if (e.getMessage().contains("Unsupported major.minor version 51.0")) {
                return null;
            }
            throw new IllegalArgumentException("Could not load plugin class '" + pluginClassName + "'", e);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Could not load plugin class '" + pluginClassName + "'", e);
        }
        if (!Plugin.class.isAssignableFrom(klass)) {
            throw new IllegalArgumentException("Plugin class '" + pluginClassName + "' does not implement " + Plugin.class);
        }
        try {
            instance = klass.newInstance();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Could not create instance of plugin class '" + pluginClassName + "'", e);
        }
        Plugin plugin = (Plugin)instance;
        PluginInfoImpl info = new PluginInfoImpl();
        info.setJarName(jarName);
        info.setClassName(pluginClassName);
        PluginUtil.readInfo(plugin, info);
        return info;
    }

    private static String getPluginClassNameFromManifest(InputStream in) {
        Manifest mf = PluginUtil.readManifest(in);
        Attributes attrs = mf.getMainAttributes();
        if (attrs == null) {
            throw new IllegalArgumentException("Main attributes not found in manifest");
        }
        String implementationTitle = attrs.getValue("Implementation-Title");
        if ("JRebel".equals(implementationTitle)) {
            throw new IllegalArgumentException("JRebel agent provided instead of plugin");
        }
        String pluginClassName = attrs.getValue(MANIFEST_ATTRIBUTE_PLUGIN);
        if (pluginClassName == null) {
            throw new IllegalArgumentException("Attribute 'JavaRebel-Plugin' not found in manifest");
        }
        return pluginClassName;
    }

    private static Manifest readManifest(InputStream in) {
        try {
            Manifest manifest = new Manifest(in);
            return manifest;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read manifest from", e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }

    private static void readInfo(Plugin plugin, PluginInfoImpl info) {
        try {
            String id = plugin.getId();
            if (id == null) {
                throw new IllegalArgumentException("Plugin have no ID");
            }
            info.setId(id);
        }
        catch (AbstractMethodError e) {
            throw new IllegalArgumentException("Plugin class does not have a getId() method");
        }
        try {
            info.setName(plugin.getName());
        }
        catch (AbstractMethodError e) {
            // empty catch block
        }
        try {
            info.setDescription(plugin.getDescription());
        }
        catch (AbstractMethodError e) {
            // empty catch block
        }
        try {
            info.setAuthor(plugin.getAuthor());
        }
        catch (AbstractMethodError e) {
            // empty catch block
        }
        try {
            info.setWebsite(plugin.getWebsite());
        }
        catch (AbstractMethodError e) {
            // empty catch block
        }
        try {
            info.setSupportedVersions(plugin.getSupportedVersions());
        }
        catch (AbstractMethodError e) {
            // empty catch block
        }
        try {
            info.setTestedVersions(plugin.getTestedVersions());
        }
        catch (AbstractMethodError abstractMethodError) {
            // empty catch block
        }
    }

    private static void postProcess(Collection<PluginInfo> infos, Properties props) {
        if (props == null) {
            return;
        }
        try {
            Iterator<PluginInfo> it = infos.iterator();
            while (it.hasNext()) {
                PluginInfoImpl info = (PluginInfoImpl)it.next();
                String value = props.getProperty(info.getId());
                if (value == null) continue;
                String[] tokens = value.split(" ");
                HashSet<String> values = new HashSet<String>(Arrays.asList(tokens));
                if (values.remove("true")) {
                    info.setEnabledByDefault(true);
                }
                if (values.remove("false")) {
                    info.setEnabledByDefault(false);
                }
                if (values.remove("core")) {
                    info.setCorePlugin(true);
                }
                if (values.size() > 0) {
                    Item category;
                    String s = (String)values.iterator().next();
                    if (s.equals("lr-disabled")) {
                        values.remove("lr-disabled");
                        s = (String)values.iterator().next();
                    }
                    if ((category = PluginUtil.parseCategory(s)) != null) {
                        info.setCategory(category);
                    }
                }
                if (!values.remove("lr-only")) continue;
                it.remove();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static Item parseCategory(String str) {
        Item[] categories = PluginCategory.ALL;
        for (int i = 0; i < categories.length; ++i) {
            Item item = categories[i];
            if (!item.getId().equals(str)) continue;
            return item;
        }
        return null;
    }

    private static Properties loadProperties(InputStream is) {
        Properties result = null;
        try {
            Properties props = new Properties();
            props.load(is);
            result = props;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }
}

