/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.cli;

import com.zeroturnaround.serversetup.cli.Processor;
import com.zeroturnaround.serversetup.cli.exceptions.ProcessorException;
import com.zeroturnaround.serversetup.cli.terminal.AutoAcknowledger;
import com.zeroturnaround.serversetup.cli.terminal.TerminalUserAcknowledger;
import com.zeroturnaround.serversetup.investigator.dsl.impl.EnvironmentUtil;
import java.io.File;
import java.io.InputStreamReader;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    private static final String DEFAULT_JREBEL_PATH = "../jrebel.jar";
    public static final String OPTION_HELP = "h";
    public static final String OPTION_ROOT = "r";
    public static final String OPTION_AUTOACK = "y";
    public static final String OPTION_DRYRUN = "dr";
    public static final String OPTION_NOBACKUP = "nb";
    public static final String OPTION_DOMAINLIST = "d";
    public static final String OPTION_JREBELPATH = "jr";
    public static final String OPTION_VERBOSE = "v";
    public static final String OPTION_ALLDOMAINS = "all";
    public static final String OPTION_ROLLBACK = "rb";
    public static final String OPTION_REMOTING = "rt";
    public static final String OPTION_JAVAHOME = "jh";
    public static final String OPTION_JVMPARAM = "D";

    public static void main(String ... args) {
        if (args.length == 0) {
            Main.printHelp();
            System.exit(1);
        }
        GnuParser cliParser = new GnuParser();
        try {
            CommandLine commandLine = cliParser.parse(Main.getOptions(), args);
            if (commandLine.hasOption(OPTION_HELP)) {
                Main.printHelp();
            } else {
                Main.process(commandLine);
            }
        }
        catch (ParseException ex) {
            System.err.println("Command line parsing failed. ERROR: " + ex.getMessage());
            System.exit(666);
        }
        catch (ProcessorException ex) {
            System.err.println("ERROR: " + ex.getMessage());
            System.exit(667);
        }
    }

    private static void process(CommandLine cli) throws ParseException {
        Processor.ProcessorBuilder builder = Processor.build();
        if (!cli.hasOption(OPTION_ROOT)) {
            throw new ParseException("You have to define the root folder for the server or its domain (the last one works not for all servers).");
        }
        builder.setRoot(new File(cli.getOptionValue(OPTION_ROOT)));
        if (cli.hasOption(OPTION_NOBACKUP)) {
            builder.disableBackup();
        }
        if (cli.hasOption(OPTION_JREBELPATH)) {
            builder.setJRebelPath(new File(cli.getOptionValue(OPTION_JREBELPATH)));
        } else {
            builder.setJRebelPath(new File("./", DEFAULT_JREBEL_PATH));
        }
        if (cli.hasOption(OPTION_REMOTING)) {
            builder.remote();
        }
        if (cli.hasOption(OPTION_DOMAINLIST)) {
            builder.setDomains(cli.getOptionValues(OPTION_DOMAINLIST));
        }
        if (cli.hasOption(OPTION_VERBOSE)) {
            builder.verbose();
        }
        if (cli.hasOption(OPTION_ALLDOMAINS)) {
            builder.allDomains();
        }
        if (cli.hasOption(OPTION_DRYRUN)) {
            builder.dryRun();
        }
        if (cli.hasOption(OPTION_JAVAHOME)) {
            builder.setJavaHome(cli.getOptionValue(OPTION_JAVAHOME));
        }
        if (cli.hasOption(OPTION_ROLLBACK)) {
            builder.rollback();
        }
        if (cli.hasOption(OPTION_AUTOACK)) {
            builder.setAcknowledger(new AutoAcknowledger());
        } else {
            builder.setAcknowledger(new TerminalUserAcknowledger(System.out, new InputStreamReader(System.in)));
        }
        if (cli.hasOption(OPTION_JREBELPATH) && (EnvironmentUtil.isLinux() || EnvironmentUtil.isMac())) {
            for (char c : cli.getOptionValue(OPTION_JREBELPATH).toCharArray()) {
                if (!Character.isWhitespace(c)) continue;
                throw new ParseException("You're running on OS which doesn't work well with whitespace chars in paths. Please make sure that the path to jrebel.jar does not contain whitespace character.");
            }
        }
        if (cli.hasOption(OPTION_DOMAINLIST) && cli.hasOption(OPTION_ALLDOMAINS)) {
            throw new ParseException("You have defined both -all and -d options.");
        }
        Properties jvmProperties = cli.getOptionProperties(OPTION_JVMPARAM);
        for (String s : jvmProperties.stringPropertyNames()) {
            String value = jvmProperties.getProperty(s);
            builder.addJVMProperty(s, value);
        }
        builder.setOut(System.out);
        builder.setErr(System.err);
        builder.create().process();
    }

    private static void printHelp() {
        Main.printHeader();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Options:", Main.getOptions());
    }

    private static void printHeader() {
        if (System.out != null) {
            System.out.println("The Utility to tune server containers to work with JRebel.\nCopyright (C) 2013 ZeroTurnaround O\u00dc (http://www.zeroturnaround.com)");
            System.out.println("All questions and bugs please send to support@zeroturnaround.com");
            System.out.println();
        }
    }

    private static Options getOptions() {
        Options result = new Options();
        result.addOption(new Option(OPTION_JREBELPATH, null, true, "Path to the jrebel.jar (by default the path is ../jrebel.jar)"));
        result.addOption(new Option(OPTION_HELP, "?", false, "This list of options"));
        result.addOption(new Option(OPTION_DOMAINLIST, "domains", true, "List of domains to be processed to be used with JRebel, use ',' as the name separator"));
        result.addOption(new Option(OPTION_ROOT, "root", true, "The Server or Domain root folder"));
        result.addOption(new Option(OPTION_NOBACKUP, "nobackup", false, "Disable backup of changed files"));
        result.addOption(new Option(OPTION_DRYRUN, "dryrun", false, "Write list of possible changed files for the container without any real writing operation"));
        result.addOption(new Option(OPTION_VERBOSE, "verbose", false, "Verbose"));
        result.addOption(new Option(OPTION_ALLDOMAINS, "alldomains", false, "Process all domains of a server"));
        result.addOption(new Option(OPTION_ROLLBACK, "rollback", false, "Rollback changes in server configuration"));
        result.addOption(new Option(OPTION_AUTOACK, "yes", false, "Positive acknowledgement for all questions"));
        result.addOption(new Option(OPTION_REMOTING, "remoting", false, "Prepare container for remote work"));
        result.addOption(new Option(OPTION_JAVAHOME, "javahome", true, "The java home to be used to start external java based processes"));
        OptionBuilder.withArgName("property=value");
        OptionBuilder.hasArgs(2);
        OptionBuilder.withValueSeparator();
        OptionBuilder.withDescription("Set value to the given JVM property");
        Option propertyOption = OptionBuilder.create(OPTION_JVMPARAM);
        result.addOption(propertyOption);
        result.getOption(OPTION_DOMAINLIST).setArgs(-2);
        result.getOption(OPTION_DOMAINLIST).setValueSeparator(',');
        result.getOption(OPTION_ROOT).setRequired(true);
        return result;
    }
}

