/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.cli;

import com.zeroturnaround.serversetup.cli.exceptions.ProcessorException;
import com.zeroturnaround.serversetup.cli.terminal.UserAcknowledger;
import com.zeroturnaround.serversetup.cli.utils.InputStreamConsumer;
import com.zeroturnaround.serversetup.investigator.RuleSolver;
import com.zeroturnaround.serversetup.investigator.assertions.Assertion;
import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.ServerRuleSet;
import com.zeroturnaround.serversetup.investigator.dsl.ServerType;
import com.zeroturnaround.serversetup.investigator.dsl.impl.EnvironmentUtil;
import com.zeroturnaround.serversetup.investigator.dsl.impl.ServerDSLContextFactory;
import com.zeroturnaround.serversetup.updater.modifiers.AbstractModifier;
import com.zeroturnaround.serversetup.updater.modifiers.ChangedFile;
import com.zeroturnaround.serversetup.updater.modifiers.ModifierFactory;
import com.zeroturnaround.serversetup.updater.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.zeroturnaround.jrebel.client.spi.SimpleJRebelClientAdapter;

public class Processor {
    private static final int MAX_PATHLEN = 64;
    private final ProcessorBuilder configuration;
    private volatile ContainerInfo lastContainerInfo;
    private volatile List<ChangedFile> changedFiles;

    public List<ChangedFile> getChangeList() {
        return Collections.unmodifiableList(this.changedFiles);
    }

    public static ProcessorBuilder build() {
        return new ProcessorBuilder();
    }

    private Processor(ProcessorBuilder configuration) {
        SimpleJRebelClientAdapter.initIfMissing();
        this.configuration = configuration;
    }

    public ContainerInfo getLastContainerInfo() {
        return this.lastContainerInfo;
    }

    private Collection<File> getDomainsForProcessing(ContainerInfo containerInfo, ProcessorBuilder cfg) {
        if (containerInfo.getType().isDomainBased()) {
            HashSet<File> domainsToProcess = new HashSet<File>();
            File[] detectedDomains = containerInfo.getDomainFolders();
            if (detectedDomains == null) {
                throw new ProcessorException("Can't find any domain for the server, may be the root is wrong or the configuration is not supported.");
            }
            if (detectedDomains.length == 0) {
                throw new ProcessorException("Can't find any domain for the server, may be the root is wrong or the configuration is not supported.");
            }
            if (cfg.isDomainNamesDefined()) {
                for (String domainName : cfg.domainNames) {
                    File detectedDomain = null;
                    for (File f : detectedDomains) {
                        if (!f.getName().equals(domainName)) continue;
                        detectedDomain = f;
                        break;
                    }
                    this.printExtra("Detected domain for name '" + domainName + "' -> " + (detectedDomain == null ? "Not Found!" : FilenameUtils.normalize(detectedDomain.getAbsolutePath())));
                    if (detectedDomain == null) {
                        throw new ProcessorException("Can't find domain folder for name '" + domainName + '\'');
                    }
                    domainsToProcess.add(detectedDomain);
                }
                return domainsToProcess;
            }
            if (cfg.processAllDomains) {
                domainsToProcess.addAll(Arrays.asList(detectedDomains));
            }
            return domainsToProcess;
        }
        return Collections.emptySet();
    }

    private List<ChangedFile> getListOfChanges(ContainerInfo info, AbstractModifier modifier) {
        List<ChangedFile> changed;
        ServerDSLContext context = ServerDSLContextFactory.getInstance().make(info.getRoot());
        try {
            Properties envProperties = new Properties();
            if (this.configuration.remote) {
                envProperties.setProperty("rebel.remoting_plugin", "true");
            }
            for (String s : this.configuration.jvmProperties.keySet()) {
                String value = (String)this.configuration.jvmProperties.get(s);
                envProperties.setProperty(s, value);
            }
            changed = modifier.process(context, info, this.configuration.jrebelPath, envProperties);
        }
        catch (IOException ex) {
            throw new ProcessorException("Can't prepare for usage with jrebel for an exception [" + ex.getMessage() + ']', ex);
        }
        if (changed == null || changed.isEmpty()) {
            throw new ProcessorException("Impossible to prepare for usage with jrebel. The Application couldn't find configuration files, may be there were some changes in configuration.");
        }
        return changed;
    }

    private static File makeBackupFileCopy(File fileToBackup) {
        return Processor.makeBackupFileCopy(fileToBackup, true);
    }

    private void deleteAllBackupFiles(File file) {
        String filename = file.getName();
        Collection files = FileUtils.listFiles(file.getParentFile(), new WildcardFileFilter(filename + "*.jr.bak"), FileFilterUtils.falseFileFilter());
        for (File f : files) {
            String filePath = FilenameUtils.normalize(f.getAbsolutePath());
            this.printExtra("Deleting backup file " + filePath);
            if (f.delete()) continue;
            this.printInfo("Can't delete backup file " + filePath);
        }
    }

    private File findLastBackupCopy(File file) {
        String filename = file.getName();
        String absoluteLast = filename + ".last.jr.bak";
        Collection files = FileUtils.listFiles(file.getParentFile(), new WildcardFileFilter(filename + "*.jr.bak"), FileFilterUtils.falseFileFilter());
        Pattern fileOnlyDataPattern = Pattern.compile("^.*\\.(\\d\\d)_(\\d\\d)_(\\d\\d)\\.jr.bak$", 2);
        Pattern fileDataWithNumberPattern = Pattern.compile("^.*\\.(\\d\\d)_(\\d\\d)_(\\d\\d)\\.(\\d+)\\.jr.bak$", 2);
        File absoluteLastFile = null;
        File maxBackupVersionFile = null;
        if (!files.isEmpty()) {
            if (files.size() == 1) {
                maxBackupVersionFile = (File)files.iterator().next();
            } else {
                ArrayList<SortableNumeredFile> listToBeSorted = new ArrayList<SortableNumeredFile>();
                for (File f : files) {
                    long year;
                    long month;
                    long day;
                    String fileName = f.getName();
                    if (absoluteLast.equals(fileName)) {
                        absoluteLastFile = f;
                        continue;
                    }
                    Matcher matcher = fileOnlyDataPattern.matcher(fileName);
                    Matcher matcherWithNumber = fileDataWithNumberPattern.matcher(fileName);
                    long index = -1L;
                    if (matcher.find()) {
                        day = Long.parseLong(fileName.substring(matcher.start(1), matcher.end(1)));
                        month = Long.parseLong(fileName.substring(matcher.start(2), matcher.end(2)));
                        year = Long.parseLong(fileName.substring(matcher.start(3), matcher.end(3)));
                        index = year << 32 | month << 24 | day << 16;
                    } else if (matcherWithNumber.find()) {
                        day = Long.parseLong(fileName.substring(matcherWithNumber.start(1), matcherWithNumber.end(1)));
                        month = Long.parseLong(fileName.substring(matcherWithNumber.start(2), matcherWithNumber.end(2)));
                        year = Long.parseLong(fileName.substring(matcherWithNumber.start(3), matcherWithNumber.end(3)));
                        long number = Long.parseLong(fileName.substring(matcherWithNumber.start(4), matcherWithNumber.end(4)));
                        index = year << 32 | month << 24 | day << 16 | number;
                    }
                    if (index < 0L) continue;
                    listToBeSorted.add(new SortableNumeredFile(index, f));
                }
                Collections.sort(listToBeSorted);
                if (!listToBeSorted.isEmpty()) {
                    maxBackupVersionFile = ((SortableNumeredFile)listToBeSorted.get(0)).getFile();
                }
            }
        }
        return absoluteLastFile == null ? maxBackupVersionFile : absoluteLastFile;
    }

    private static File makeBackupFileCopy(File fileToBackup, boolean allowSave) {
        File result = null;
        if (fileToBackup.isFile()) {
            String date = new SimpleDateFormat("dd_MM_yy").format(new Date());
            String backupfileName = fileToBackup.getName() + "." + date;
            result = new File(fileToBackup.getParentFile(), backupfileName + ".jr.bak");
            if (result.exists()) {
                for (int i = 1; i < 10000 && (result = new File(fileToBackup.getParentFile(), backupfileName + '.' + i + ".jr.bak")).exists(); ++i) {
                    result = null;
                }
                if (result == null) {
                    result = new File(fileToBackup.getParentFile(), backupfileName + '.' + ".last.jr.bak");
                }
            }
            if (allowSave) {
                try {
                    FileUtils.copyFile(fileToBackup, result);
                }
                catch (IOException ex) {
                    throw new ProcessorException("Can't backup file " + FilenameUtils.normalize(fileToBackup.getAbsolutePath()) + " as " + FilenameUtils.normalize(result.getAbsolutePath()));
                }
            }
        }
        return result;
    }

    private ContainerInfo checkAndPrepareDomains(ContainerInfo info) {
        ContainerInfo result;
        if (info.getType().isDomainBased()) {
            Collection<File> domainsToProcess = this.getDomainsForProcessing(this.lastContainerInfo, this.configuration);
            if (domainsToProcess.isEmpty()) {
                this.printServerTree(info);
                throw new ProcessorException("Agent installation failed. No domain name specified. Either use -all to apply to all domains, or specify domain names using -d argument.");
            }
            this.printExtra("Domains to be processed");
            this.printExtra("----------------------------");
            for (File f : domainsToProcess) {
                this.printExtra(f.getName() + " -> " + FilenameUtils.normalize(f.getAbsolutePath()));
            }
            this.printExtra("----------------------------");
            result = new ContainerInfo(this.lastContainerInfo.getRoot(), this.lastContainerInfo.getType(), this.lastContainerInfo.getVersion(), domainsToProcess.toArray(new File[domainsToProcess.size()]));
        } else {
            result = info;
        }
        return result;
    }

    private void printListOfFiles(List<ChangedFile> listOfFiles) {
        this.printInfo("");
        this.printInfo(" List of new files or modified files");
        this.printInfo("----------------------------------------");
        int index = 1;
        for (ChangedFile file : listOfFiles) {
            this.printInfo(index + ":\t" + FilenameUtils.normalize(file.getDestinationFile().getAbsolutePath()));
            ++index;
        }
        this.printInfo("----------------------------------------");
    }

    private void doRollback(ContainerInfo info, AbstractModifier modifier, boolean dryRun) throws IOException {
        this.printInfo("Preparing to do rollback");
        ContainerInfo preparedContainer = this.checkAndPrepareDomains(info);
        this.changedFiles = this.getListOfChanges(preparedContainer, modifier);
        this.printInfo("");
        if (!info.getType().isDomainBased()) {
            if (dryRun) {
                this.printInfo("Generated files wold be deleted");
                this.printInfo("-----------------------------");
                for (ChangedFile f : this.changedFiles) {
                    File file = f.getDestinationFile();
                    if (!file.isFile()) continue;
                    String path = StringUtils.shortStr(64, FilenameUtils.normalize(file.getAbsolutePath()));
                    this.printInfo("File " + path + " would be deleted");
                }
            } else {
                this.printInfo("Deleting generated files");
                this.printInfo("-----------------------------");
                for (ChangedFile f : this.changedFiles) {
                    File file = f.getDestinationFile();
                    if (!file.isFile()) continue;
                    String path = StringUtils.shortStr(64, FilenameUtils.normalize(file.getAbsolutePath()));
                    if (this.configuration.acknowledger.getAcknowledgeFromUser("Remove file " + path + "?")) {
                        this.printInfo("Deleting file " + path + " ");
                        if (!file.delete()) {
                            throw new IOException("Can't delete file " + path);
                        }
                    }
                    this.deleteAllBackupFiles(file);
                }
            }
        } else {
            this.printInfo(dryRun ? "Information about possible restoration" : "Restoring original files from backup copies");
            for (ChangedFile f : this.changedFiles) {
                File currentfile = f.getDestinationFile();
                String currentFilePath = StringUtils.shortStr(64, FilenameUtils.normalize(currentfile.getAbsolutePath()));
                File backupCopy = this.findLastBackupCopy(currentfile);
                if (backupCopy == null) {
                    this.printInfo("Can't find any backup file for " + currentFilePath);
                    continue;
                }
                String backupFilePath = StringUtils.shortStr(64, FilenameUtils.normalize(backupCopy.getAbsolutePath()));
                if (dryRun) {
                    this.printInfo("File " + currentFilePath + " would be restored fro " + backupFilePath);
                    continue;
                }
                if (!this.configuration.acknowledger.getAcknowledgeFromUser("Restore " + currentfile.getName() + " from " + backupFilePath + "?")) continue;
                this.printExtra("Deleting " + currentFilePath);
                if (currentfile.isFile() && !currentfile.delete()) {
                    throw new IOException("Can't delete the current file " + currentFilePath);
                }
                this.printExtra("Restoring backup copy " + backupFilePath);
                if (!backupCopy.renameTo(currentfile)) {
                    throw new IOException("Can't rename " + backupFilePath + " to " + currentFilePath);
                }
                this.printInfo("Restored " + currentFilePath + " from " + backupFilePath);
                this.deleteAllBackupFiles(currentfile);
            }
        }
    }

    private void doModify(ContainerInfo info, AbstractModifier modifier, boolean dryRun, boolean disableBackup) throws IOException {
        this.printInfo("Preparing to do modification");
        this.printInfo("The Path to jrebel.jar: " + FilenameUtils.normalize(this.configuration.jrebelPath.getAbsolutePath()));
        ContainerInfo preparedContainer = this.checkAndPrepareDomains(info);
        this.changedFiles = this.getListOfChanges(preparedContainer, modifier);
        this.printInfo("Detected container : " + preparedContainer.toString());
        if (!this.configuration.acknowledger.getAcknowledgeFromUser("Is the server container correct?")) {
            throw new ProcessorException("Wrong server container detection, the process has been canceled");
        }
        this.printListOfFiles(this.changedFiles);
        if (!dryRun) {
            if (!this.configuration.acknowledger.getAcknowledgeFromUser("Do you agree the changes?")) {
                throw new ProcessorException("The process has been canceled");
            }
            this.printExtra("Starting save files");
            for (ChangedFile f : this.changedFiles) {
                File thefile = f.getDestinationFile();
                String thefilepath = FilenameUtils.normalize(thefile.getAbsolutePath());
                if (!disableBackup) {
                    this.printExtra("Making backup for:\t" + thefilepath);
                    File backup = Processor.makeBackupFileCopy(thefile);
                    if (backup == null) {
                        this.printInfo("Can't make backup for file:\t" + thefilepath);
                    } else {
                        this.printInfo("Backup version saved:\t" + thefilepath + " -> " + FilenameUtils.normalize(backup.getAbsolutePath()));
                    }
                    try {
                        FileUtils.writeStringToFile(thefile, f.getTextAsString());
                        this.printInfo("Saved new file:\t" + thefilepath);
                        if (!f.isExecutable() || this.makeFileExecutable(thefile)) continue;
                        this.printWarningInfo("Can't make the file '" + thefilepath + "' as an executable one, please make it manually, may be the process just doesn't have enough rights.");
                        continue;
                    }
                    catch (IOException ex) {
                        throw new ProcessorException("Can't override file " + thefilepath, ex);
                    }
                }
                this.printInfo("Backup is turned off!");
            }
            if (info.getType() == ServerType.WAS) {
                this.processJRebelBootstrapGeneration(info);
            } else {
                this.printExtra("The server is not WAS so that bootstrap classes processing ignored");
            }
        }
    }

    private void processJRebelBootstrapGeneration(ContainerInfo info) throws IOException {
        File jrebel = this.configuration.jrebelPath;
        this.printWarningInfo("You use server container which desired bootstrap classes to work with JRebel.");
        if (this.configuration.acknowledger.getAcknowledgeFromUser("Do you agree to prepare bootstrap classes?")) {
            File javaExecutableFile = null;
            if (this.configuration.javaHome == null) {
                List<String> detectedJavaHome = info.getExtraProperty("java.home");
                for (String s : detectedJavaHome) {
                    if (!this.configuration.acknowledger.getAcknowledgeFromUser("Do you agree to use the JAVA_HOME: " + FilenameUtils.normalize(s) + "?")) continue;
                    javaExecutableFile = this.getJavaExecutable(s);
                }
                if (javaExecutableFile == null && this.configuration.acknowledger.getAcknowledgeFromUser("Does your server container use the current Java distributive?")) {
                    javaExecutableFile = this.getJavaExecutable(System.getProperty("java.home"));
                }
            } else {
                javaExecutableFile = this.getJavaExecutable(this.configuration.javaHome);
            }
            String jrebelJarPath = StringUtils.prepareStringForCLI(FilenameUtils.normalize(jrebel.getAbsolutePath()));
            String str = StringUtils.prepareStringForCLI(FilenameUtils.normalize(javaExecutableFile.getAbsolutePath())) + " -jar " + jrebelJarPath;
            this.printExtra("Starting external process: " + str);
            Process process = Runtime.getRuntime().exec(str);
            try {
                int error = process.waitFor();
                if (error != 0) {
                    this.printWarningInfo("Could not generate jrebel bootstrap for an error [" + error + ']');
                } else {
                    this.printInfo("JRebel bootstrap has been generated successfuly");
                }
            }
            catch (InterruptedException ex) {
                throw new ProcessorException("Process has been interrupted");
            }
        }
    }

    private File getJavaExecutable(String javaHome) throws IOException {
        File javaHomeFolder = new File(javaHome);
        if (!javaHomeFolder.isDirectory()) {
            throw new ProcessorException("Can't find java home folder " + FilenameUtils.normalize(javaHome));
        }
        String javaExecutable = EnvironmentUtil.isWindows() ? "java.exe" : "java";
        File javaExecutableFile = new File(javaHomeFolder, EnvironmentUtil.isWindows() ? "bin/java.exe" : "bin/java");
        if (!javaExecutableFile.isFile()) {
            throw new ProcessorException("Can't find " + FilenameUtils.normalize(javaExecutableFile.getAbsolutePath()));
        }
        return javaExecutableFile;
    }

    public void process() {
        this.lastContainerInfo = null;
        this.printExtra("Start processing");
        this.checkData();
        RuleSolver solver = new RuleSolver(this.configuration.root, new ServerRuleSet[0]);
        if (!solver.solve()) {
            throw new ProcessorException("Can't figure out the server type and its version, may be the root path is wrong?");
        }
        List<ContainerInfo> containerInfoList = solver.getContainerInfo();
        if (containerInfoList.size() != 1) {
            throw new ProcessorException("Multivariant container recognition detected! Contact developer please! (" + containerInfoList + ')');
        }
        this.lastContainerInfo = containerInfoList.get(0);
        AbstractModifier serverModifier = ModifierFactory.getInstance().make(this.lastContainerInfo);
        if (serverModifier == null) {
            throw new ProcessorException("Detected unsupported server type or server version [" + this.lastContainerInfo.toString() + ']');
        }
        try {
            if (this.configuration.rollback) {
                this.doRollback(this.lastContainerInfo, serverModifier, this.configuration.dryRun);
            } else {
                this.doModify(this.lastContainerInfo, serverModifier, this.configuration.dryRun, this.configuration.disableBackup);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Detected IO exception", ex);
        }
        this.printExtra("Processing has been completed");
    }

    private void printServerTree(ContainerInfo info) {
        if (info == null) {
            return;
        }
        this.printInfo("-----------------------------------------------------");
        this.printInfo("");
        this.printInfo(info.toString());
        if (info.getType().isDomainBased()) {
            this.printInfo("  |");
            File[] domains = info.getDomainFolders();
            if (domains == null) {
                this.printInfo("  \\--DOMAINS OR THEIR FOLDER NOT FOUND");
            } else {
                if (domains.length == 0) {
                    this.printInfo("  \\--CAN'T FIND ANY DOMAIN");
                }
                boolean notFirst = false;
                for (int i = 0; i < domains.length - 1; ++i) {
                    File domain = domains[i];
                    if (notFirst) {
                        this.printInfo("  |");
                    } else {
                        notFirst = true;
                    }
                    this.printInfo("  +--" + domain.getName() + (this.configuration.verbose ? " [" + FilenameUtils.normalize(domain.getAbsolutePath()) + ']' : ""));
                }
                File domain = domains[domains.length - 1];
                if (notFirst) {
                    this.printInfo("  |");
                }
                this.printInfo("  \\--" + domain.getName() + (this.configuration.verbose ? " [" + FilenameUtils.normalize(domain.getAbsolutePath()) + ']' : ""));
            }
        }
        this.printInfo("");
        this.printInfo("-----------------------------------------------------");
    }

    private void printWarningInfo(String str) {
        if (this.configuration.outStream != null) {
            this.configuration.outStream.println("===================================================================");
            this.configuration.outStream.println("         WARNING!!! WARNING!!! WARNING!!! WARNING!!! ");
            this.configuration.outStream.println("-------------------------------------------------------------------");
            this.configuration.outStream.println(str);
            this.configuration.outStream.println("===================================================================");
        }
    }

    private void printInfo(String str) {
        if (this.configuration.outStream != null) {
            this.configuration.outStream.println(str);
        }
    }

    private void printError(String str) {
        if (this.configuration.errStream != null) {
            this.configuration.errStream.println("[ERROR] " + str);
        }
    }

    private void printExtra(String str) {
        if (this.configuration.verbose && str != null) {
            this.printInfo("[*] " + str);
        }
    }

    private void checkData() {
        this.printExtra("Start data checking");
        if (this.configuration.root == null) {
            throw new ProcessorException("Agent installation failed. The root folder is not defined. Please specify server folder using -r argument.");
        }
        this.printExtra("The Defined root folder is " + FilenameUtils.normalize(this.configuration.root.getAbsolutePath()));
        if (this.configuration.dryRun) {
            this.printExtra("Detected flag to prepare container for JRebel");
            if (this.configuration.jrebelPath == null) {
                throw new ProcessorException("Agent installation failed. No path to jrebel.jar specified. Please specify path to jrebel.jar using -jr argument");
            }
            this.printExtra("The Defined jrebel.jar path is " + FilenameUtils.normalize(this.configuration.jrebelPath.getAbsolutePath()));
        }
        this.printExtra("Data checking has been completed successfuly");
    }

    private boolean makeFileExecutable(File filePath) {
        if (EnvironmentUtil.isMac() || EnvironmentUtil.isLinux()) {
            String normalizedFilePath = FilenameUtils.normalize(filePath.getAbsolutePath());
            try {
                String[] args = new String[]{"chmod", "+x", normalizedFilePath};
                String commandLine = "";
                for (String s : args) {
                    commandLine = normalizedFilePath == s ? commandLine + normalizedFilePath.replace(" ", "\\ ") : commandLine + " " + s;
                }
                this.printInfo("Executing the command: " + commandLine);
                Process process = Runtime.getRuntime().exec(args);
                InputStreamConsumer outStream = new InputStreamConsumer(process.getInputStream());
                outStream.startProcessing();
                InputStreamConsumer errStream = new InputStreamConsumer(process.getErrorStream());
                errStream.startProcessing();
                int exitValue = process.waitFor();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    return false;
                }
                this.printInfo(outStream.getOutputAsString());
                if (exitValue != 0) {
                    this.printError(errStream.getOutputAsString());
                    this.printError("Process has returned " + exitValue);
                    return false;
                }
                return true;
            }
            catch (Exception ex) {
                this.printError("Exception during command execution : " + ex.getMessage());
                return false;
            }
        }
        return true;
    }

    public static class ProcessorBuilder {
        private File jrebelPath;
        private File root;
        private String[] domainNames;
        private boolean dryRun;
        private boolean rollback;
        private boolean disableBackup;
        private boolean remote;
        private boolean locked;
        private PrintStream outStream = null;
        private PrintStream errStream = null;
        private boolean verbose;
        private boolean processAllDomains;
        private UserAcknowledger acknowledger;
        private String javaHome = null;
        private Map<String, String> jvmProperties = new HashMap<String, String>();

        private ProcessorBuilder() {
        }

        private void assertNotLocked() {
            if (this.locked) {
                throw new IllegalStateException("An Attempt to use a closed builder");
            }
        }

        public ProcessorBuilder addJVMProperty(String name, String value) {
            this.assertNotLocked();
            if (name == null) {
                throw new NullPointerException("Name is null");
            }
            if (value == null) {
                throw new NullPointerException("Value is null");
            }
            this.jvmProperties.put(name, value);
            return this;
        }

        public boolean isDomainNamesDefined() {
            return this.domainNames != null && this.domainNames.length > 0;
        }

        public ProcessorBuilder setJavaHome(String javaHomePath) {
            this.assertNotLocked();
            this.javaHome = javaHomePath;
            return this;
        }

        public ProcessorBuilder allDomains() {
            this.assertNotLocked();
            this.processAllDomains = true;
            return this;
        }

        public ProcessorBuilder verbose() {
            this.assertNotLocked();
            this.verbose = true;
            return this;
        }

        public ProcessorBuilder remote() {
            this.assertNotLocked();
            this.remote = true;
            return this;
        }

        public ProcessorBuilder setOut(PrintStream out) {
            this.assertNotLocked();
            Assertion.notNull(out);
            this.outStream = out;
            return this;
        }

        public ProcessorBuilder setErr(PrintStream out) {
            this.assertNotLocked();
            Assertion.notNull(out);
            this.errStream = out;
            return this;
        }

        public ProcessorBuilder setJRebelPath(File path) throws ParseException {
            this.assertNotLocked();
            Assertion.notNull(path);
            if (!path.isFile()) {
                throw new ParseException("Can't find the jrebel.jar for the path [" + FilenameUtils.normalize(path.getAbsolutePath()) + ']');
            }
            this.jrebelPath = path;
            return this;
        }

        public ProcessorBuilder setRoot(File path) throws ParseException {
            this.assertNotLocked();
            Assertion.notNull(path);
            if (!path.isDirectory()) {
                throw new ParseException("Can't find the root folder [" + path.getAbsolutePath() + ']');
            }
            this.root = path;
            return this;
        }

        public ProcessorBuilder setDomains(String ... names) {
            this.assertNotLocked();
            Assertion.notNulls(new Object[]{names});
            this.domainNames = (String[])names.clone();
            return this;
        }

        public ProcessorBuilder rollback() {
            this.assertNotLocked();
            this.rollback = true;
            return this;
        }

        public ProcessorBuilder setAcknowledger(UserAcknowledger acknowledger) {
            this.assertNotLocked();
            this.acknowledger = acknowledger;
            return this;
        }

        public ProcessorBuilder dryRun() {
            this.assertNotLocked();
            this.dryRun = true;
            return this;
        }

        public ProcessorBuilder disableBackup() {
            this.assertNotLocked();
            this.disableBackup = true;
            return this;
        }

        public Processor create() {
            this.assertNotLocked();
            this.locked = true;
            return new Processor(this);
        }
    }

    private static final class SortableNumeredFile
    implements Comparable<SortableNumeredFile> {
        private final long index;
        private final File file;

        public SortableNumeredFile(long index, File file) {
            this.index = index;
            this.file = file;
        }

        public long getIndex() {
            return this.index;
        }

        public File getFile() {
            return this.file;
        }

        @Override
        public int compareTo(SortableNumeredFile other) {
            return this.index < other.index ? -1 : (this.index == other.index ? 0 : 1);
        }
    }
}

