/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.cli.terminal;

import com.zeroturnaround.serversetup.cli.terminal.UserAcknowledger;
import com.zeroturnaround.serversetup.investigator.assertions.Assertion;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Locale;

public class TerminalUserAcknowledger
implements UserAcknowledger {
    private final PrintStream writer;
    private final Reader reader;

    public TerminalUserAcknowledger(PrintStream writer, Reader reader) {
        Assertion.notNulls(writer, reader);
        this.writer = writer;
        this.reader = reader;
    }

    @Override
    public boolean getAcknowledgeFromUser(String request) throws IOException {
        while (true) {
            this.writer.print(request + " (Y/N): ");
            StringBuilder buffer = new StringBuilder(32);
            while (true) {
                int code;
                if ((code = this.reader.read()) < 0) {
                    throw new EOFException("terminal has been closed");
                }
                if (code == 10) break;
                buffer.append((char)code);
            }
            String text = buffer.toString().trim().toLowerCase(Locale.ENGLISH);
            if (text.equals("y") || text.equals("ye") || text.equals("yes")) {
                return true;
            }
            if (text.equals("n") || text.equals("no") || text.equals("not")) {
                return false;
            }
            this.writer.println("**ERROR** Can't recognize your answer [" + text + ']');
        }
    }
}

