/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.investigator;

import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.OperatingSystem;
import com.zeroturnaround.serversetup.investigator.dsl.ServerRuleSet;
import com.zeroturnaround.serversetup.investigator.dsl.impl.ServerDSLContextFactory;
import com.zeroturnaround.serversetup.investigator.dsl.impl.ServerDSLContextImpl;
import com.zeroturnaround.serversetup.investigator.serverrules.RulesGlassfishVersion;
import com.zeroturnaround.serversetup.investigator.serverrules.RulesJBossVersion;
import com.zeroturnaround.serversetup.investigator.serverrules.RulesJettyVersion;
import com.zeroturnaround.serversetup.investigator.serverrules.RulesTomcatVersion;
import com.zeroturnaround.serversetup.investigator.serverrules.RulesTomeeVersion;
import com.zeroturnaround.serversetup.investigator.serverrules.RulesWeblogicVersion;
import com.zeroturnaround.serversetup.investigator.serverrules.RulesWebsphereVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleSolver {
    private final File rootFolder;
    private final ServerRuleSet[] rules;
    private final OperatingSystem definedOperatingSystem;
    private volatile List<ContainerInfo> containerInfos;

    private static ServerRuleSet[] getAllServerRuleSets() {
        return new ServerRuleSet[]{new RulesGlassfishVersion(), new RulesJBossVersion(), new RulesJettyVersion(), new RulesTomcatVersion(), new RulesTomeeVersion(), new RulesWeblogicVersion(), new RulesWebsphereVersion()};
    }

    public RuleSolver(File rootFolder, ServerRuleSet ... rules) {
        this(rootFolder, (OperatingSystem)null, rules);
    }

    public RuleSolver(File rootFolder, OperatingSystem os, ServerRuleSet ... rules) {
        this.rootFolder = rootFolder;
        this.rules = rules != null && rules.length != 0 ? rules : RuleSolver.getAllServerRuleSets();
        this.definedOperatingSystem = os;
    }

    public boolean solve() {
        this.containerInfos = new ArrayList<ContainerInfo>();
        ServerDSLContextImpl context = (ServerDSLContextImpl)ServerDSLContextFactory.getInstance().make(this.rootFolder);
        if (this.definedOperatingSystem != null) {
            context.setOperatingSystem(this.definedOperatingSystem);
        }
        boolean result = false;
        for (ServerRuleSet r : this.rules) {
            r.init(context);
            boolean resultOfSet = r.check();
            if (resultOfSet) {
                this.containerInfos.add(r.getContainerInfo());
            }
            result |= resultOfSet;
        }
        return result;
    }

    public List<ContainerInfo> getContainerInfo() {
        return this.containerInfos;
    }
}

