/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.investigator.dsl;

import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ServerType {
    GAE(false, "Google AppEngine"),
    GERONIMO(false, "Geronimo"),
    GLASSFISH(true, "GlassFish"),
    JBOSS(false, "JBoss"),
    JETTY(false, "Jetty"),
    OC4J(false, "OC4J"),
    RESIN(false, "Resin"),
    TOMCAT(false, "Tomcat"),
    TOMEE(false, "TomEE"),
    VIRGO(false, "Virgo"),
    WAS(true, "WebSphere"),
    WEBLOGIC(true, "WebLogic"),
    UNKNOWN(false, "Unknown");

    private final boolean domainBased;
    private final String displayName;

    private ServerType(boolean domainBased, String displayName) {
        this.domainBased = domainBased;
        this.displayName = displayName;
    }

    public String displayName() {
        return this.displayName;
    }

    public boolean isDomainBased() {
        return this.domainBased;
    }

    public static ServerType fromString(String serverName) {
        if (serverName == null || serverName.length() == 0) {
            return null;
        }
        String normalizedName = serverName.trim().toUpperCase(Locale.ENGLISH);
        ServerType result = null;
        for (ServerType serverType : ServerType.values()) {
            if (!serverType.name().equals(normalizedName)) continue;
            result = serverType;
        }
        if (result == null && "WEBSPHERE".equals(normalizedName)) {
            result = WAS;
        }
        return result;
    }
}

