/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.investigator.dsl.impl;

import com.zeroturnaround.serversetup.investigator.assertions.Assertion;
import com.zeroturnaround.serversetup.investigator.dsl.OperatingSystem;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.exceptions.ConditionIsFalseException;
import com.zeroturnaround.serversetup.investigator.dsl.exceptions.NotFoundException;
import com.zeroturnaround.serversetup.investigator.dsl.exceptions.ServerSetupDSLException;
import com.zeroturnaround.serversetup.investigator.dsl.exceptions.StringNotFoundException;
import com.zeroturnaround.serversetup.investigator.dsl.impl.EnvironmentUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerDSLContextImpl
implements ServerDSLContext {
    private final File rootFolder;
    private File currentFolder;
    private File currentOpenedTextFile;
    private List<String> loadedTextFile;
    private int foundStringIndex = -1;
    private static Charset UTF8 = Charset.forName("UTF8");
    private OperatingSystem directDefinedOperationgSystem;

    ServerDSLContextImpl(File rootFolder) {
        Assertion.notNull(rootFolder);
        this.rootFolder = rootFolder;
        this.currentFolder = rootFolder;
    }

    @Override
    public ServerDSLContext reset() {
        this.currentFolder = this.rootFolder;
        this.loadedTextFile = null;
        this.currentOpenedTextFile = null;
        this.foundStringIndex = -1;
        return this;
    }

    public void setOperatingSystem(OperatingSystem os) {
        this.directDefinedOperationgSystem = os;
    }

    @Override
    public ServerDSLContext resetStringFinder() {
        this.foundStringIndex = -1;
        return this;
    }

    @Override
    public void fail() {
        throw new ConditionIsFalseException("Failed");
    }

    @Override
    public String getFoundString() {
        if (this.loadedTextFile == null) {
            throw new IllegalStateException("There is not any opened file");
        }
        return this.foundStringIndex < 0 ? null : this.loadedTextFile.get(this.foundStringIndex);
    }

    @Override
    public String getStringPartAfterChar(char symbol) {
        String str = this.getFoundString();
        if (str == null) {
            throw new IllegalStateException("There is not any found string");
        }
        int index = str.indexOf(symbol);
        return index < 0 ? str : str.substring(index + 1);
    }

    @Override
    public String getTextForXPath(String xPath) {
        Assertion.notNull(xPath);
        String string = this.getOpenedTextFileAsString();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            try {
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException e) {
                // empty catch block
            }
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            docBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    return new InputSource(new StringReader(""));
                }
            });
            Document document = docBuilder.parse(new ByteArrayInputStream(string.getBytes(UTF8.name())));
            XPath path = XPathFactory.newInstance().newXPath();
            return path.compile(xPath).evaluate(document);
        }
        catch (XPathExpressionException ex) {
            throw new ConditionIsFalseException("Can't find xml node '" + xPath + "' or parse the file as xml");
        }
        catch (ParserConfigurationException ex) {
            throw new RuntimeException("Wrong parser configuration [" + xPath + ']', ex);
        }
        catch (SAXException ex) {
            throw new ConditionIsFalseException("Can't parse xml document [" + xPath + ']');
        }
        catch (IOException ex) {
            throw new ConditionIsFalseException("Can't parse xml document [" + xPath + ']');
        }
    }

    @Override
    public ServerDSLContext findManifestProperty(String manifestPropertyName) {
        int i;
        Assertion.notNull(manifestPropertyName);
        if (this.loadedTextFile == null) {
            throw new IllegalStateException("Not opened text file");
        }
        int n = i = this.foundStringIndex < 0 ? 0 : this.foundStringIndex + 1;
        while (i < this.loadedTextFile.size()) {
            String name;
            int delimiter;
            String str = this.loadedTextFile.get(i).trim();
            if (str.length() != 0 && (delimiter = str.indexOf(58)) >= 0 && manifestPropertyName.equals(name = str.substring(0, delimiter).trim())) {
                this.foundStringIndex = i;
                return this;
            }
            ++i;
        }
        throw new StringNotFoundException("Manifest property named '" + manifestPropertyName + "' is not found");
    }

    @Override
    public ServerDSLContext findProperty(String propertyName) {
        int i;
        Assertion.notNull(propertyName);
        if (this.loadedTextFile == null) {
            throw new IllegalStateException("Not opened text file");
        }
        int n = i = this.foundStringIndex < 0 ? 0 : this.foundStringIndex + 1;
        while (i < this.loadedTextFile.size()) {
            String name;
            int delimiter;
            String str = this.loadedTextFile.get(i).trim();
            if (str.length() != 0 && !str.startsWith("#") && (delimiter = str.indexOf(61)) >= 0 && propertyName.equals(name = str.substring(0, delimiter).trim())) {
                this.foundStringIndex = i;
                return this;
            }
            ++i;
        }
        throw new StringNotFoundException("Property named '" + propertyName + "' is not found");
    }

    @Override
    public ServerDSLContext findStringStartsWith(String stringStart) {
        int i;
        Assertion.notNull(stringStart);
        if (stringStart.length() == 0) {
            throw new IllegalArgumentException("Empty string can't be an argument");
        }
        if (this.loadedTextFile == null) {
            throw new IllegalStateException("Not opened text file");
        }
        int n = i = this.foundStringIndex < 0 ? 0 : this.foundStringIndex + 1;
        while (i < this.loadedTextFile.size()) {
            String str = this.loadedTextFile.get(i);
            if (str.startsWith(stringStart)) {
                this.foundStringIndex = i;
                return this;
            }
            ++i;
        }
        throw new StringNotFoundException("Not found any string starts with '" + stringStart + "'");
    }

    @Override
    public ServerDSLContext findStringEndsWith(String stringEnd) {
        int i;
        Assertion.notNull(stringEnd);
        if (stringEnd.length() == 0) {
            throw new IllegalArgumentException("Empty string can't be an argument");
        }
        if (this.loadedTextFile == null) {
            throw new IllegalStateException("Not opened text file");
        }
        int n = i = this.foundStringIndex < 0 ? 0 : this.foundStringIndex + 1;
        while (i < this.loadedTextFile.size()) {
            String str = this.loadedTextFile.get(i);
            if (str.endsWith(stringEnd)) {
                this.foundStringIndex = i;
                return this;
            }
            ++i;
        }
        throw new StringNotFoundException("Not found any string ends with '" + stringEnd + "'");
    }

    @Override
    public ServerDSLContext findStringForPattern(Pattern pattern) {
        int i;
        Assertion.notNull(pattern);
        if (this.loadedTextFile == null) {
            throw new IllegalStateException("Not opened text file");
        }
        int n = i = this.foundStringIndex < 0 ? 0 : this.foundStringIndex + 1;
        while (i < this.loadedTextFile.size()) {
            String str = this.loadedTextFile.get(i);
            if (pattern.matcher(str).matches()) {
                this.foundStringIndex = i;
                return this;
            }
            ++i;
        }
        throw new StringNotFoundException("Not found any string for pattern '" + pattern + "'");
    }

    @Override
    public String getOpenedTextFileAsString() {
        if (this.loadedTextFile == null) {
            throw new IllegalStateException("There is not any loaded file");
        }
        StringBuilder builder = new StringBuilder(4096);
        for (String s : this.loadedTextFile) {
            builder.append(s).append('\n');
        }
        return builder.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ServerDSLContext openTextFile(String file) {
        Assertion.notNull(file);
        this.foundStringIndex = -1;
        File theFile = this.findOnlyExistsFile(file, true);
        BufferedInputStream theFileInputStream = null;
        try {
            theFileInputStream = new BufferedInputStream(new FileInputStream(theFile), 16384);
            this.loadedTextFile = IOUtils.readLines(theFileInputStream);
            this.currentOpenedTextFile = theFile;
            if (theFileInputStream == null) return this;
        }
        catch (FileNotFoundException ex) {
            try {
                throw new NotFoundException("Can't find file [" + file + ']');
                catch (Exception ex2) {
                    throw new RuntimeException("Unexpected file read exception [" + file + ']', ex2);
                }
            }
            catch (Throwable throwable) {
                if (theFileInputStream == null) throw throwable;
                IOUtils.closeQuietly(theFileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(theFileInputStream);
        return this;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ServerDSLContext openArchiveEntry(String file) {
        ServerDSLContextImpl serverDSLContextImpl;
        block9: {
            Assertion.notNull(file);
            this.foundStringIndex = -1;
            int entryNameIndex = file.indexOf(33);
            if (entryNameIndex < 0) {
                throw new IllegalArgumentException("Wrong format of an archive entry, it must use '!' as the separator [" + file + ']');
            }
            String fileName = file.substring(0, entryNameIndex);
            String entryName = file.substring(entryNameIndex + 1);
            File theFile = this.findOnlyExistsFile(fileName, true);
            BufferedInputStream theFileInputStream = null;
            try {
                ArchiveEntry entry;
                theFileInputStream = new BufferedInputStream(new FileInputStream(theFile), 16384);
                ArchiveInputStream archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream(theFileInputStream);
                this.currentOpenedTextFile = theFile;
                do {
                    if ((entry = archiveInputStream.getNextEntry()) != null) continue;
                    throw new NotFoundException(file);
                } while (entry.isDirectory() || !entry.getName().equals(entryName));
                this.loadedTextFile = IOUtils.readLines(archiveInputStream);
                serverDSLContextImpl = this;
                if (theFileInputStream == null) break block9;
            }
            catch (FileNotFoundException ex) {
                try {
                    throw new NotFoundException(fileName);
                    catch (Exception ex2) {
                        if (ex2 instanceof ServerSetupDSLException) {
                            throw (ServerSetupDSLException)ex2;
                        }
                        throw new RuntimeException("Unexpected exception [" + file + ']', ex2);
                    }
                }
                catch (Throwable throwable) {
                    if (theFileInputStream != null) {
                        IOUtils.closeQuietly(theFileInputStream);
                    }
                    throw throwable;
                }
            }
            IOUtils.closeQuietly(theFileInputStream);
        }
        return serverDSLContextImpl;
    }

    @Override
    public List<String> getOpenedTextFile() {
        if (this.loadedTextFile == null) {
            return null;
        }
        return Collections.unmodifiableList(this.loadedTextFile);
    }

    @Override
    public ServerDSLContext backToRootFolder() {
        this.currentFolder = this.rootFolder;
        return this;
    }

    @Override
    public OperatingSystem getOS() {
        if (this.directDefinedOperationgSystem != null) {
            return this.directDefinedOperationgSystem;
        }
        if (EnvironmentUtil.isLinux()) {
            return OperatingSystem.LINUX;
        }
        if (EnvironmentUtil.isWindows()) {
            return OperatingSystem.WINDOWS;
        }
        if (EnvironmentUtil.isMac()) {
            return OperatingSystem.MAC_OS;
        }
        return OperatingSystem.UNKNOWN;
    }

    @Override
    public ServerDSLContext isOperatingSystem(OperatingSystem os) {
        Assertion.notNull((Object)os);
        if (this.directDefinedOperationgSystem != null) {
            if (this.directDefinedOperationgSystem != os) {
                throw new ConditionIsFalseException("It is not Linux");
            }
            return this;
        }
        switch (os) {
            case LINUX: {
                if (EnvironmentUtil.isLinux()) break;
                throw new ConditionIsFalseException("It is not Linux");
            }
            case MAC_OS: {
                if (EnvironmentUtil.isMac()) break;
                throw new ConditionIsFalseException("It is not MAC OS");
            }
            case WINDOWS: {
                if (EnvironmentUtil.isWindows()) break;
                throw new ConditionIsFalseException("It is not WINDOWS");
            }
            case UNKNOWN: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Detected unsupported OS entry");
            }
        }
        return this;
    }

    @Override
    public ServerDSLContext folderExists(String folderName) {
        Assertion.notNull(folderName);
        File theFolder = this.findOnlyExistsFile(folderName, true);
        if (!theFolder.isDirectory()) {
            throw new NotFoundException("Folder " + folderName + " doesn't exist");
        }
        return this;
    }

    @Override
    public ServerDSLContext gotoFolder(String ... folderNames) {
        Assertion.notNulls(folderNames);
        for (String s : folderNames) {
            File theNextFolder;
            this.currentFolder = theNextFolder = this.findOnlyExistsFile(s, false);
        }
        return this;
    }

    @Override
    public ServerDSLContext fileExists(String fileName) {
        WildcardFileFilter filter;
        File[] files;
        Assertion.notNull(fileName);
        if (ServerDSLContextImpl.isWildCard(fileName)) {
            throw new IllegalArgumentException("The method doesn't support wildcards");
        }
        if (ServerDSLContextImpl.isWildCard(fileName) ? (files = this.currentFolder.listFiles(filter = new WildcardFileFilter(fileName))) == null || files.length == 0 : !new File(this.currentFolder, fileName).exists()) {
            throw new ConditionIsFalseException("File " + fileName + " doesn't exist");
        }
        return this;
    }

    @Override
    public File getRoot() {
        return this.rootFolder;
    }

    @Override
    public File getCurrentFolder() {
        return this.currentFolder;
    }

    private static boolean isWildCard(String name) {
        return name.indexOf(42) >= 0 || name.indexOf(63) >= 0;
    }

    private File findOnlyExistsFile(String name, final boolean selectFiles) {
        if (ServerDSLContextImpl.isWildCard(name)) {
            WildcardFileFilter filter = new WildcardFileFilter(name){
                private static final long serialVersionUID = -9192815128005030538L;

                public boolean accept(File dir, String name) {
                    if (selectFiles) {
                        return false;
                    }
                    return super.accept(dir, name);
                }

                public boolean accept(File file) {
                    if (selectFiles ? file.isDirectory() : !file.isDirectory()) {
                        return false;
                    }
                    return super.accept(file);
                }
            };
            File[] files = this.currentFolder.listFiles(filter);
            if (files == null) {
                files = new File[]{};
            }
            switch (files.length) {
                case 0: {
                    throw new NotFoundException("File '" + name + "' is not found");
                }
                case 1: {
                    return files[0];
                }
            }
            throw new ConditionIsFalseException("Detected a few files for '" + name + "'");
        }
        File result = new File(this.currentFolder, name);
        if (selectFiles) {
            if (!result.isFile()) {
                throw new NotFoundException("File '" + result.getAbsolutePath() + "' is not found");
            }
        } else if (!result.isDirectory()) {
            throw new NotFoundException("Folder '" + result.getAbsolutePath() + "' is not found");
        }
        return result;
    }

    @Override
    public File getOpenedFile() {
        if (this.currentOpenedTextFile == null) {
            throw new IllegalStateException("there is no any opened text file");
        }
        return this.currentOpenedTextFile;
    }

    private static Collection<File> getAllFoldersAt(File folder, String pattern) {
        if (!folder.exists() || folder.isFile()) {
            return Collections.emptyList();
        }
        WildcardFileFilter wildcardFolderFilter = new WildcardFileFilter(pattern){
            private static final long serialVersionUID = -9192815128005030538L;

            public boolean accept(File dir, String name) {
                return dir.isDirectory() && super.accept(dir, name);
            }

            public boolean accept(File file) {
                return file.isDirectory() && super.accept(file);
            }
        };
        File[] file = folder.listFiles(wildcardFolderFilter);
        return Arrays.asList(file);
    }

    private static Collection<File> getAllSubfoldersFromPath(File root, String ... pathFolders) {
        if (pathFolders == null || pathFolders.length == 0) {
            return ServerDSLContextImpl.getAllFoldersAt(root, "*");
        }
        Collection<File> folders = ServerDSLContextImpl.getAllFoldersAt(root, pathFolders[0]);
        if (folders.isEmpty()) {
            return Collections.emptyList();
        }
        String[] nextPath = new String[pathFolders.length - 1];
        System.arraycopy(pathFolders, 1, nextPath, 0, nextPath.length);
        ArrayList<File> result = new ArrayList<File>();
        for (File f : folders) {
            result.addAll(ServerDSLContextImpl.getAllSubfoldersFromPath(f, nextPath));
        }
        return result;
    }

    @Override
    public Collection<File> findWildcardedFoldersForPath(String ... pathFolders) {
        return ServerDSLContextImpl.getAllSubfoldersFromPath(this.currentFolder, pathFolders);
    }
}

