/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.investigator.serverrules;

import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.ServerRuleSet;
import com.zeroturnaround.serversetup.investigator.dsl.ServerType;
import com.zeroturnaround.serversetup.investigator.dsl.ServerVersion;
import java.io.File;

public class RulesJBossVersion
extends ServerRuleSet {
    private static boolean checkThatVersionRight(ContainerInfo info) {
        if (info == null) {
            return false;
        }
        ServerVersion version = info.getVersion();
        if (version == null) {
            return false;
        }
        int[] versionNumbers = version.getVersion();
        return versionNumbers.length >= 1 && versionNumbers[0] > 1;
    }

    public boolean rule_JBossVersion_ServerRoot_7_1_1() {
        this.getContext().gotoFolder("bin", "client").openArchiveEntry("jboss-client.jar!META-INF/MANIFEST.MF");
        String version = this.getContext().findManifestProperty("JBossAS-Release-Version").getStringPartAfterChar(':').trim();
        this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.JBOSS, RulesJBossVersion.extractVersionWithDottedPostfix(version), null);
        return RulesJBossVersion.checkThatVersionRight(this.containerInfo);
    }

    public boolean rule_JBossVersion_ServerRoot_7_0_0() {
        this.getContext().gotoFolder("bundles", "org", "jboss", "as", "osgi", "configadmin", "main").openArchiveEntry("jboss-as-osgi-configadmin-*.jar!META-INF/MANIFEST.MF");
        String version = this.getContext().findManifestProperty("Bundle-Version").getStringPartAfterChar(':').trim();
        this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.JBOSS, RulesJBossVersion.extractVersionWithDottedPostfix(version), null);
        return RulesJBossVersion.checkThatVersionRight(this.containerInfo);
    }

    public boolean rule_JBoss_51_and_61() {
        this.getContext().gotoFolder("lib").openArchiveEntry("jboss-main.jar!META-INF/MANIFEST.MF");
        String version = this.getContext().findManifestProperty("Specification-Version").getStringPartAfterChar(':').trim();
        this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.JBOSS, RulesJBossVersion.extractVersionWithDottedPostfix(version), null);
        return RulesJBossVersion.checkThatVersionRight(this.containerInfo);
    }

    public boolean rule_JBoss_4() {
        this.getContext().gotoFolder("lib").openArchiveEntry("jboss-common.jar!META-INF/MANIFEST.MF");
        String version = this.getContext().findManifestProperty("Specification-Version").getStringPartAfterChar(':').trim();
        this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.JBOSS, RulesJBossVersion.extractVersionWithDottedPostfix(version), null);
        return RulesJBossVersion.checkThatVersionRight(this.containerInfo);
    }

    public boolean rule_JBoss_421() {
        this.getContext().gotoFolder("lib").openArchiveEntry("jboss-system.jar!META-INF/MANIFEST.MF");
        String version = this.getContext().findManifestProperty("Specification-Version").getStringPartAfterChar(':').trim();
        this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.JBOSS, RulesJBossVersion.extractVersionWithDottedPostfix(version), null);
        return RulesJBossVersion.checkThatVersionRight(this.containerInfo);
    }

    public boolean rule_JBoss_5() {
        this.getContext().gotoFolder("lib").openArchiveEntry("jboss-bootstrap.jar!META-INF/MANIFEST.MF");
        String version = this.getContext().findManifestProperty("Specification-Version").getStringPartAfterChar(':').trim();
        this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.JBOSS, RulesJBossVersion.extractVersionWithDottedPostfix(version), null);
        return RulesJBossVersion.checkThatVersionRight(this.containerInfo);
    }

    public void checkServerType(ServerDSLContext context) {
        if (RulesJBossVersion.fileExists(context, "bin", "client", "jboss-client.jar") || RulesJBossVersion.fileExists(context, "bundles", "org", "jboss", "as", "osgi", "configadmin", "main", "jboss-as-osgi-configadmin-*.jar") || RulesJBossVersion.fileExists(context, "lib", "jboss-main.jar") || RulesJBossVersion.fileExists(context, "lib", "jboss-common.jar") || RulesJBossVersion.fileExists(context, "lib", "jboss-system.jar") || RulesJBossVersion.fileExists(context, "lib", "jboss-bootstrap.jar")) {
            this.containerInfo = new ContainerInfo(context.getRoot(), ServerType.JBOSS, new ServerVersion(), new File[0]);
        }
    }
}

