/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.investigator.serverrules;

import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.OperatingSystem;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.ServerRuleSet;
import com.zeroturnaround.serversetup.investigator.dsl.ServerType;
import com.zeroturnaround.serversetup.investigator.dsl.ServerVersion;
import com.zeroturnaround.serversetup.investigator.dsl.impl.ServerDSLContextFactory;
import java.io.File;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RulesWeblogicVersion
extends ServerRuleSet {
    public void rule_WeblogicVersion_ServerRoot() {
        this.processForServerFolder(this.getContext().getRoot());
    }

    private void processForServerFolder(File folder) {
        ServerDSLContext context = ServerDSLContextFactory.getInstance().make(folder);
        String version = context.gotoFolder("wlserver*", "server", "lib").openArchiveEntry("weblogic.jar!META-INF/MANIFEST.MF").findManifestProperty("Implementation-Version").getStringPartAfterChar(':');
        this.containerInfo = new ContainerInfo(context.getRoot(), ServerType.WEBLOGIC, new ServerVersion(version), this.processDomainRegistry());
    }

    public boolean rule_WebLogicVersion_DomainRoot() {
        String pathToServer;
        OperatingSystem os = this.getContext().getOS();
        switch (os) {
            case LINUX: 
            case MAC_OS: {
                pathToServer = this.getContext().openTextFile("startWebLogic.sh").findStringForPattern(Pattern.compile("^\\s*domain_home\\s*=.*", 2)).getStringPartAfterChar('=').trim();
                break;
            }
            case WINDOWS: {
                pathToServer = this.getContext().openTextFile("startWebLogic.cmd").findStringForPattern(Pattern.compile("^\\s*set\\s*domain_home\\s*=.*", 2)).getStringPartAfterChar('=').trim();
                break;
            }
            default: {
                return false;
            }
        }
        this.processForServerFolder(this.checkFolderAndChangeIfNeed(new File(this.removeQuotes(pathToServer))));
        if (this.containerInfo.getDomainFolders() == null) {
            this.containerInfo = new ContainerInfo(this.containerInfo.getRoot(), this.containerInfo.getType(), this.containerInfo.getVersion(), new File[]{this.getContext().getRoot()});
        } else {
            boolean foundTheDomainFolder = false;
            for (File f : this.containerInfo.getDomainFolders()) {
                if (!this.getContext().getRoot().equals(f)) continue;
                foundTheDomainFolder = true;
                break;
            }
            if (!foundTheDomainFolder) {
                File[] oldDomainFolders = this.containerInfo.getDomainFolders();
                File[] newDomainFolders = new File[oldDomainFolders.length + 1];
                System.arraycopy(oldDomainFolders, 0, newDomainFolders, 0, oldDomainFolders.length);
                newDomainFolders[oldDomainFolders.length] = this.getContext().getRoot();
                this.containerInfo = new ContainerInfo(this.containerInfo.getRoot(), this.containerInfo.getType(), this.containerInfo.getVersion(), newDomainFolders);
            }
        }
        return true;
    }

    private File[] processDomainRegistry() {
        try {
            String text = this.getContext().reset().openTextFile("domain-registry.xml").getOpenedTextFileAsString();
            Document xmlDoc = this.parseStringAsXMLDocument(text);
            XPath xpath = XPathFactory.newInstance().newXPath();
            NodeList domainList = (NodeList)xpath.evaluate("//domain[@location]", xmlDoc.getDocumentElement(), XPathConstants.NODESET);
            File[] result = new File[domainList.getLength()];
            for (int i = 0; i < domainList.getLength(); ++i) {
                Element node = (Element)domainList.item(i);
                String path = node.getAttribute("location");
                result[i] = this.checkFolderAndChangeIfNeed(new File(path));
            }
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void checkServerType(ServerDSLContext context) {
        if (RulesWeblogicVersion.fileExists(context, "wlserver*", "server", "lib", "weblogic.jar")) {
            this.containerInfo = new ContainerInfo(context.getRoot(), ServerType.WEBLOGIC, new ServerVersion(), new File[0]);
        }
    }
}

