/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.investigator.serverrules;

import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.ServerRuleSet;
import com.zeroturnaround.serversetup.investigator.dsl.ServerType;
import com.zeroturnaround.serversetup.investigator.dsl.ServerVersion;
import com.zeroturnaround.serversetup.investigator.dsl.exceptions.ConditionIsFalseException;
import com.zeroturnaround.serversetup.investigator.dsl.impl.ServerDSLContextFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesWebsphereVersion
extends ServerRuleSet {
    private static final Pattern WEBLOGIC_MACROS = Pattern.compile("\\$\\{(.+)\\}");

    public void rule_WebsphereVersion_ServerRoot() {
        String version = this.getContext().gotoFolder("properties", "version").openTextFile("WAS.product").getTextForXPath("/product/version");
        Collection<File> domainRoots = this.getContext().reset().findWildcardedFoldersForPath("profiles", "*", "config", "cells", "*", "nodes", "*", "servers");
        List<String> javaHome = this.findJavaHome();
        Map<String, List<String>> extra = Collections.singletonMap("java.home", javaHome);
        this.containerInfo = new ContainerInfo(this.getContext().getRoot(), ServerType.WAS, new ServerVersion(version), domainRoots.toArray(new File[domainRoots.size()]), extra);
    }

    private List<String> findJavaHome() {
        Collection<File> nodeFolders = this.getContext().reset().findWildcardedFoldersForPath("profiles", "*", "config", "cells", "*", "nodes");
        ArrayList<String> result = new ArrayList<String>();
        for (File folder : nodeFolders) {
            ServerDSLContext context = ServerDSLContextFactory.getInstance().make(folder);
            try {
                context.openTextFile("variables.xml");
                String javaHome = this.findValue("JAVA_HOME", context);
                result.add(javaHome);
            }
            catch (ConditionIsFalseException ex) {}
        }
        return result;
    }

    private String findValue(String name, ServerDSLContext context) {
        String str = context.openTextFile("variables.xml").getTextForXPath("/*/entries[@symbolicName='" + name + "']/@value");
        Matcher macros = WEBLOGIC_MACROS.matcher(str);
        while (macros.find()) {
            String value = this.findValue(str.substring(macros.start(1), macros.end(1)), context);
            str = str.substring(0, macros.start()) + value + str.substring(macros.end());
            macros = WEBLOGIC_MACROS.matcher(str);
        }
        return str;
    }

    @Override
    public void checkServerType(ServerDSLContext context) {
        if (RulesWebsphereVersion.fileExists(context, "properties", "version", "WAS.product")) {
            this.containerInfo = new ContainerInfo(context.getRoot(), ServerType.WAS, new ServerVersion(), new File[0]);
        }
    }
}

