/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.updater.modifiers;

import com.zeroturnaround.serversetup.updater.modifiers.AbstractModifier;
import java.io.File;
import java.util.List;
import org.apache.commons.io.FilenameUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangedFile {
    private final File originalFile;
    private final File destinationFile;
    private final String newBody;
    private final boolean executable;
    private boolean isBackup;

    public ChangedFile(File sourceFile, File destinationFile, String text, boolean executable) {
        this.originalFile = sourceFile;
        this.destinationFile = destinationFile;
        this.newBody = text;
        this.executable = executable;
    }

    public static ChangedFile newOrModification(File scriptFile, String text, boolean executable) {
        File sourceFile = scriptFile.exists() ? scriptFile : null;
        return new ChangedFile(sourceFile, scriptFile, text, executable);
    }

    public static ChangedFile removal(File file, boolean executable) {
        return new ChangedFile(file, null, null, executable);
    }

    public List<String> getTextAsStringList() {
        return AbstractModifier.split(this.newBody);
    }

    public String getTextAsString() {
        return this.newBody;
    }

    public File getSourceFile() {
        return this.originalFile;
    }

    public File getDestinationFile() {
        return this.destinationFile;
    }

    public boolean isNew() {
        return this.originalFile == null;
    }

    public boolean isModification() {
        return this.originalFile != null && this.destinationFile != null;
    }

    public boolean isRemoval() {
        return this.destinationFile == null;
    }

    public boolean isExecutable() {
        return this.executable;
    }

    public boolean isBackup() {
        return this.isBackup;
    }

    public void setBackup(boolean isBackup) {
        this.isBackup = isBackup;
    }

    private static String fileToPath(File file) {
        if (file == null) {
            return "";
        }
        return FilenameUtils.normalize(file.getAbsolutePath());
    }

    public String toString() {
        return ChangedFile.fileToPath(this.destinationFile);
    }
}

