/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.updater.modifiers;

import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.ServerType;
import com.zeroturnaround.serversetup.investigator.dsl.exceptions.NotFoundException;
import com.zeroturnaround.serversetup.updater.exceptions.CantProcessDomainException;
import com.zeroturnaround.serversetup.updater.model.Domain;
import com.zeroturnaround.serversetup.updater.modifiers.AbstractModifier;
import com.zeroturnaround.serversetup.updater.modifiers.ChangedFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.store.GlassFishXmlArgStore;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.jrebel.client.JRebel;
import org.zeroturnaround.jrebel.client.spi.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassfishModifier
extends AbstractModifier {
    @Override
    public boolean isJRebelEnabled(Domain domain, JRebel jrebel) throws IOException {
        File domainXmlFile = this.getDomainXml(domain.location);
        return jrebel.isEnabledIn(new GlassFishXmlArgStore(domainXmlFile));
    }

    @Override
    public List<ChangedFile> setJRebelEnabled(ServerDSLContext context, Domain domain, JRebel jrebel, boolean enable, Properties envProperties, ProgressMonitor monitor) throws IOException {
        File domainXmlFile = this.getDomainXml(domain.location);
        JavaVM vm = domain.getSelectedJavaOrFallback();
        GlassFishXmlArgStore argStore = new GlassFishXmlArgStore(domainXmlFile);
        try {
            ArgChanges changes;
            ArgChanges argChanges = changes = enable ? jrebel.getInstallationArguments(vm, monitor) : jrebel.getUndoInstallationArguments();
            if (enable) {
                changes.merge(this.asArgChanges(envProperties));
            }
            String newContent = argStore.preview(changes);
            return Collections.singletonList(new ChangedFile(domainXmlFile, domainXmlFile, newContent, false));
        }
        catch (Exception e) {
            throw new CantProcessDomainException("Error changing jvm arguments", domain.location, e);
        }
    }

    private File getDomainXml(File domainRoot) {
        File domainXmlFile = new File(domainRoot, "config/domain.xml");
        if (!domainXmlFile.exists()) {
            throw new NotFoundException("Can't find file [" + domainXmlFile + ']');
        }
        return domainXmlFile;
    }

    @Override
    public boolean isVersionSupported(ContainerInfo info) {
        if (info.getType() == ServerType.GLASSFISH) {
            return !info.getVersion().versionBefore(3) && info.getVersion().versionBefore(5);
        }
        return false;
    }

    public String toString() {
        return "Glassfish Modifier v1.0";
    }
}

