/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.updater.modifiers;

import com.zeroturnaround.serversetup.investigator.assertions.Assertion;
import com.zeroturnaround.serversetup.investigator.dsl.ContainerInfo;
import com.zeroturnaround.serversetup.updater.modifiers.AbstractModifier;
import com.zeroturnaround.serversetup.updater.modifiers.GlassfishModifier;
import com.zeroturnaround.serversetup.updater.modifiers.JBossModifier;
import com.zeroturnaround.serversetup.updater.modifiers.JettyModifier;
import com.zeroturnaround.serversetup.updater.modifiers.TomcatModifier;
import com.zeroturnaround.serversetup.updater.modifiers.WeblogicModifier;
import com.zeroturnaround.serversetup.updater.modifiers.WebsphereModifier;

public class ModifierFactory {
    private static final ModifierFactory instance = new ModifierFactory();
    private static final AbstractModifier[] modifiers = new AbstractModifier[]{new GlassfishModifier(), new JBossModifier(), new JettyModifier(), new TomcatModifier(), new WeblogicModifier(), new WebsphereModifier()};

    private ModifierFactory() {
    }

    public static ModifierFactory getInstance() {
        return instance;
    }

    public AbstractModifier make(ContainerInfo containerInfo) {
        Assertion.notNull(containerInfo);
        for (AbstractModifier m : modifiers) {
            if (!m.isVersionSupported(containerInfo)) continue;
            return m;
        }
        return null;
    }
}

