/*
 * Decompiled with CFR 0.152.
 */
package com.zeroturnaround.serversetup.updater.modifiers;

import com.zeroturnaround.serversetup.investigator.dsl.OperatingSystem;
import com.zeroturnaround.serversetup.investigator.dsl.ServerDSLContext;
import com.zeroturnaround.serversetup.investigator.dsl.impl.EnvironmentUtil;
import com.zeroturnaround.serversetup.updater.model.Domain;
import com.zeroturnaround.serversetup.updater.modifiers.AbstractModifier;
import com.zeroturnaround.serversetup.updater.modifiers.ChangedFile;
import com.zeroturnaround.serversetup.updater.modifiers.Macros;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.store.StringArgStore;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.jrebel.client.JRebel;
import org.zeroturnaround.jrebel.client.spi.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScriptBasedModifier
extends AbstractModifier {
    protected static final String MACROS_JREBEL_ARGS = "jrebel_args";

    @Override
    public List<ChangedFile> setJRebelEnabled(ServerDSLContext context, Domain domain, JRebel jrebel, boolean enable, Properties envProperties, ProgressMonitor monitor) throws IOException {
        ArrayList<ChangedFile> result = new ArrayList<ChangedFile>();
        File scriptFile = this.getScriptFile(domain, context.getOS());
        if (!enable) {
            result.add(ChangedFile.removal(scriptFile, true));
        } else {
            JavaVM vm = domain.getSelectedJavaOrFallback();
            String jrebelArgs = this.evaluateJRebelArgs(jrebel, vm, envProperties, monitor);
            Set<Macros> macros = Collections.singleton(new Macros(MACROS_JREBEL_ARGS, jrebelArgs));
            result.add(this.createScript(context, domain, macros, monitor));
        }
        return result;
    }

    @Override
    public boolean isJRebelEnabled(Domain domain, JRebel jrebel) {
        return this.getScriptFile(domain, OperatingSystem.current()).exists();
    }

    protected abstract ChangedFile createScript(ServerDSLContext var1, Domain var2, Set<Macros> var3, ProgressMonitor var4) throws IOException;

    protected abstract File getScriptFile(Domain var1, OperatingSystem var2);

    protected String evaluateJRebelArgs(JRebel jrebel, JavaVM vm, Properties envProperties, ProgressMonitor monitor) {
        try {
            ArgChanges changes = jrebel.getInstallationArguments(vm, monitor);
            changes.merge(this.asArgChanges(envProperties));
            ArgFormatter formatter = EnvironmentUtil.isWindows() ? ArgFormatter.QUOTED : ArgFormatter.ID;
            return new StringArgStore("", formatter, false).preview(changes);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

