/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common;

import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerList<L> {
    private static final Object[] EmptyArray = new Object[0];
    public static final int EQUALITY = 0;
    public static final int IDENTITY = 1;
    private final boolean identity;
    private volatile Object[] listeners = EmptyArray;

    public ListenerList() {
        this(0);
    }

    public ListenerList(int mode) {
        if (mode != 0 && mode != 1) {
            throw new IllegalArgumentException();
        }
        this.identity = mode == 1;
    }

    public synchronized void add(L listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        for (int i = 0; i < oldSize; ++i) {
            Object listener2 = this.listeners[i];
            if (!(this.identity ? listener == listener2 : listener.equals(listener2))) continue;
            return;
        }
        Object[] newListeners = new Object[oldSize + 1];
        System.arraycopy(this.listeners, 0, newListeners, 0, oldSize);
        newListeners[oldSize] = listener;
        this.listeners = newListeners;
    }

    public List<L> getListeners() {
        return Arrays.asList(this.listeners);
    }

    public boolean isEmpty() {
        return this.listeners.length == 0;
    }

    public synchronized void remove(L listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.listeners.length;
        for (int i = 0; i < oldSize; ++i) {
            Object listener2 = this.listeners[i];
            if (!(this.identity ? listener == listener2 : listener.equals(listener2))) continue;
            if (oldSize == 1) {
                this.listeners = EmptyArray;
            } else {
                Object[] newListeners = new Object[oldSize - 1];
                System.arraycopy(this.listeners, 0, newListeners, 0, i);
                System.arraycopy(this.listeners, i + 1, newListeners, i, oldSize - i - 1);
                this.listeners = newListeners;
            }
            return;
        }
    }

    public int size() {
        return this.listeners.length;
    }

    public synchronized void clear() {
        this.listeners = EmptyArray;
    }
}

