/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common;

import org.zeroturnaround.common.Function0;
import org.zeroturnaround.common.Function1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Maybe<T> {
    private static final None<?> NONE = new None();

    public static <T> Maybe<T> nullable(T value) {
        return value != null ? Maybe.some(value) : Maybe.none();
    }

    public static <T> Maybe<T> some(T value) {
        return new Some(value);
    }

    public static <T> None<T> none() {
        return NONE;
    }

    public Maybe<T> orElse(Maybe<T> that) {
        return this.isDefined() ? this : that;
    }

    public Maybe<T> orElse(Function0<Maybe<T>> that) {
        return this.isDefined() ? this : that.apply();
    }

    public T getOrElse(T fallback) {
        return this.isDefined() ? this.get() : fallback;
    }

    public T getOrElse(Function0<T> fallback) {
        return this.isDefined() ? this.get() : fallback.apply();
    }

    public <U> Maybe<U> map(Function1<T, U> f) {
        return this.isDefined() ? Maybe.some(f.apply(this.get())) : Maybe.none();
    }

    public abstract boolean isDefined();

    public abstract T get();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class None<T>
    extends Maybe<T> {
        private None() {
        }

        @Override
        public boolean isDefined() {
            return false;
        }

        @Override
        public T get() {
            throw new IllegalStateException("Cannot get value from None");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Some<T>
    extends Maybe<T> {
        private final T value;

        private Some(T value) {
            this.value = value;
        }

        @Override
        public boolean isDefined() {
            return true;
        }

        @Override
        public T get() {
            return this.value;
        }
    }
}

