/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private static final String SEPARATOR = ".";
    private static final Pattern NON_DIGITS = Pattern.compile("\\D+");
    public static final Version EMPTY = new Version(0, 0, 0, "");
    private final int major;
    private final int minor;
    private final int micro;
    private final String qualifier;

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null);
    }

    public Version(int major, int minor, int micro, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.qualifier = qualifier == null ? "" : qualifier;
    }

    public Version(String specVer) {
        String[] versionParts = specVer.split("-", 2);
        String version = versionParts[0];
        String qualifier = versionParts.length > 1 ? versionParts[1] : "";
        String[] splitVersion = version.split("\\.");
        StringBuilder qualifierPrefix = new StringBuilder();
        this.major = Version.extractQualifier(splitVersion[0], qualifierPrefix);
        this.minor = splitVersion.length > 1 ? Version.extractQualifier(splitVersion[1], qualifierPrefix) : 0;
        int n = this.micro = splitVersion.length > 2 ? Version.extractQualifier(splitVersion[2], qualifierPrefix) : 0;
        this.qualifier = qualifierPrefix.length() > 0 ? (qualifier.length() > 0 ? qualifierPrefix + "-" + qualifier : qualifierPrefix.toString()) : qualifier;
    }

    private static int extractQualifier(String versionPart, StringBuilder qualifier) {
        Matcher m = NON_DIGITS.matcher(versionPart);
        if (m.find()) {
            String nonDigits = m.group();
            qualifier.append(nonDigits);
            versionPart = versionPart.replace(nonDigits, "");
        }
        return versionPart.length() > 0 ? Integer.parseInt(versionPart) : 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public int compareTo(Version other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        return this.qualifier.compareTo(other.qualifier);
    }

    public String toString() {
        int q = this.qualifier.length();
        StringBuilder result = new StringBuilder();
        result.append(this.major);
        result.append(SEPARATOR);
        result.append(this.minor);
        result.append(SEPARATOR);
        result.append(this.micro);
        if (q > 0) {
            result.append("-");
            result.append(this.qualifier);
        }
        return result.toString();
    }

    public int hashCode() {
        return (this.major << 24) + (this.minor << 16) + (this.micro << 8) + this.qualifier.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        return this.major == other.major && this.minor == other.minor && this.micro == other.micro && this.qualifier.equals(other.qualifier);
    }
}

