/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.args;

import java.util.ArrayList;
import java.util.List;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.IArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgChanges {
    public final List<IArgument> additions = new ArrayList<IArgument>();
    public final List<IArgument> removals = new ArrayList<IArgument>();

    public boolean hasAdditions() {
        return !this.additions.isEmpty();
    }

    public static ArgChanges addOne(IArgument arg) {
        ArgChanges changes = new ArgChanges();
        changes.add(arg);
        return changes;
    }

    public static ArgChanges removeOne(IArgument arg) {
        ArgChanges changes = new ArgChanges();
        changes.remove(arg);
        return changes;
    }

    public void merge(ArgChanges that) {
        this.additions.addAll(that.additions);
        this.removals.addAll(that.removals);
    }

    public List<IArgument> all() {
        ArrayList<IArgument> allChanges = new ArrayList<IArgument>(this.removals);
        allChanges.addAll(this.additions);
        return allChanges;
    }

    public void add(IArgument arg) {
        this.additions.add(arg);
    }

    public void remove(IArgument arg) {
        this.removals.add(arg);
    }

    public Maybe<IArgument> findAddition(IArgument target) {
        for (IArgument addition : this.additions) {
            if (!target.matches(addition.asString(ArgFormatter.ID))) continue;
            return Maybe.some(addition);
        }
        return Maybe.none();
    }
}

