/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.args;

import org.zeroturnaround.jrebel.client.util.ShortFilenameUtil;

public class ArgFormatter {
    public static final ArgFormatter ID = new ArgFormatter(false, false);
    public static final ArgFormatter QUOTED = new ArgFormatter(false, true);
    public static final ArgFormatter SHORT_FILE_NAMES = new ArgFormatter(true, false);
    private boolean useWindowsShortNames;
    private boolean useQuotes;

    public ArgFormatter() {
        this(false, true);
    }

    public ArgFormatter(boolean useWindowsShortNames, boolean useQuotes) {
        this.useWindowsShortNames = useWindowsShortNames;
        this.useQuotes = useQuotes;
    }

    public String formatValue(String value) {
        if (this.useQuotes && value.contains(" ")) {
            value = "\"" + value.replace("\"", "\\\"") + "\"";
        }
        return value;
    }

    public String formatPath(String path) {
        if (this.useWindowsShortNames) {
            path = ShortFilenameUtil.ifWindowsReplaceSpacesWithShortNames(path);
        } else if (this.useQuotes) {
            while (path != null && path.endsWith("\\")) {
                path = path.substring(0, path.length() - 1);
            }
            path = "\"" + path + "\"";
        }
        return path;
    }
}

