/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.args;

import java.util.regex.Pattern;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.ArgValue;
import org.zeroturnaround.common.args.ArgValueString;
import org.zeroturnaround.common.args.IArgument;
import org.zeroturnaround.common.args.parser.ArgsParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgTriple<T>
implements IArgument {
    public final String key;
    public final String separator;
    public final ArgValue<T> value;

    public ArgTriple(String key, String separator, ArgValue<T> value) {
        this.key = key;
        this.separator = separator;
        this.value = value;
    }

    public ArgTriple(String key, String separator, String value) {
        this(key, separator, new ArgValueString(value));
    }

    public String getValue(ArgFormatter formatter) {
        return this.value != null ? this.value.asString(formatter) : "";
    }

    @Override
    public boolean matches(String argStr) {
        return argStr.startsWith(this.key + this.separator);
    }

    public String toString() {
        return "ArgTriple: " + this.asString(ArgFormatter.ID);
    }

    @Override
    public String asString(ArgFormatter formatter) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.key);
        String value = this.getValue(formatter);
        if (value != null) {
            buf.append(this.separator);
            buf.append(value);
        }
        return buf.toString();
    }

    @Override
    public ArgTriple<T> fromString(String arg) {
        if (arg.startsWith(this.key)) {
            String[] kv = arg.split(Pattern.quote(this.separator), 2);
            String value = kv.length == 2 ? kv[1] : null;
            return this.withValue(ArgsParser.unquote(value));
        }
        return null;
    }

    public ArgTriple<T> withValue(String value) {
        if (this.value == null) {
            throw new IllegalStateException("Don't know the type of the argument triple value");
        }
        ArgValue<T> newValue = this.value.fromString(value);
        return new ArgTriple<T>(this.key, this.separator, newValue);
    }

    public ArgTriple<T> withValuesMatching(String regex) {
        return new WithValuesMatchingRegex(this, regex);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class WithValuesMatchingRegex<U>
    extends ArgTriple<U> {
        private final ArgTriple<U> underlying;
        private final String regex;

        public WithValuesMatchingRegex(ArgTriple<U> that, String regex) {
            super(that.key, that.separator, that.value);
            this.underlying = that;
            this.regex = regex;
        }

        @Override
        public boolean matches(String argStr) {
            String[] kv;
            if (this.underlying.matches(argStr) && (kv = argStr.split(Pattern.quote(this.separator), 2)).length == 2) {
                String v = kv[1];
                return v.matches(this.regex);
            }
            return false;
        }

        @Override
        public String getValue(ArgFormatter formatter) {
            return this.underlying.getValue(formatter);
        }

        @Override
        public ArgTriple<U> withValue(String value) {
            return new WithValuesMatchingRegex(super.withValue(value), this.regex);
        }
    }
}

