/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.args.parser;

import java.util.ArrayList;

public class ArgsParser {
    private final ArrayList<ArgWithWhitespace> args = new ArrayList();
    private final String input;
    private final int len;
    private boolean propertySupport;
    private String wsFirst = " ";
    private boolean allWsSame = true;
    private StringBuilder ws = new StringBuilder();
    private int argS = 0;
    private StringBuilder arg = new StringBuilder();
    private int loc = 0;
    private char cur = '\u0000';
    private boolean inQuotes = false;
    private boolean inProperty = false;

    private ArgsParser(String input, boolean propertySupport) {
        this.input = input;
        this.propertySupport = propertySupport;
        this.len = input.length();
    }

    public static ParsedArgs parse(String input) {
        return ArgsParser.parse(input, false);
    }

    public static ParsedArgs parse(String input, boolean propertyPatternSupport) {
        ArgsParser parser = new ArgsParser(input, propertyPatternSupport);
        parser.parseArgList();
        String separator = parser.allWsSame ? parser.wsFirst : (parser.wsFirst.contains("\n") ? parser.wsFirst : " ");
        return new ParsedArgs(parser.args.toArray(new ArgWithWhitespace[parser.args.size()]), separator);
    }

    private void parseArgList() {
        while (this.loc < this.input.length()) {
            int curPos = this.loc;
            this.read();
            if (!Character.isWhitespace(this.cur) && this.ws.length() > 0) {
                String wsCur = this.ws.toString();
                if (" ".equals(this.wsFirst)) {
                    this.wsFirst = wsCur;
                } else if (!this.wsFirst.equals(wsCur)) {
                    this.allWsSame = false;
                }
                this.ws = new StringBuilder();
            }
            if (this.propertySupport) {
                if (this.cur == '$' && this.peek() == '{') {
                    this.inProperty = true;
                }
                if (this.cur == '}') {
                    this.inProperty = false;
                }
            }
            if (this.cur == '\\' && this.peek() == '\"') {
                this.read();
            } else {
                if (this.cur == '\"' && !this.inQuotes) {
                    this.inQuotes = true;
                    continue;
                }
                if (this.cur == '\"' && this.inQuotes) {
                    this.inQuotes = false;
                    continue;
                }
                if (Character.isWhitespace(this.cur) && !this.inQuotes && !this.inProperty) {
                    if (this.arg.length() > 0) {
                        this.args.add(new ArgWithWhitespace(this.argS, this.loc, this.arg.toString()));
                        this.arg = new StringBuilder();
                    } else if (!this.args.isEmpty()) {
                        this.args.get((int)(this.args.size() - 1)).end = this.loc;
                    }
                    this.ws.append(this.cur);
                    continue;
                }
            }
            if (this.arg.length() == 0) {
                this.argS = curPos;
            }
            this.arg.append(this.cur);
        }
        if (this.arg.length() > 0) {
            this.args.add(new ArgWithWhitespace(this.argS, this.loc, this.arg.toString()));
        }
    }

    private char read() {
        this.cur = this.peek();
        ++this.loc;
        return this.cur;
    }

    private char peek() {
        if (this.loc < this.len) {
            return this.input.charAt(this.loc);
        }
        return '\u0000';
    }

    public static String unquote(String arg) {
        if (arg.startsWith("\"") && arg.endsWith("\"") && !"\"".equals(arg)) {
            return arg.substring(1, arg.length() - 1);
        }
        return arg;
    }

    public static void main(String[] args) {
        System.out.println("PROP x: " + System.getProperty("x"));
        System.out.println("PROP y: " + System.getProperty("y"));
        System.out.println("Args (length " + args.length + "):");
        for (String arg : args) {
            System.out.println(arg);
        }
    }

    public static class ParsedArgs {
        public final ArgWithWhitespace[] args;
        public final String separator;

        public ParsedArgs(ArgWithWhitespace[] args, String separator) {
            this.args = args;
            this.separator = separator;
        }
    }

    public static class ArgWithWhitespace {
        public final int start;
        public int end;
        public final String value;

        public ArgWithWhitespace(int start, int end, String value) {
            this.start = start;
            this.end = end;
            this.value = value;
        }
    }
}

