/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.args.store;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Transformer;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.IArgument;
import org.zeroturnaround.common.args.store.IPersistentArgStore;
import org.zeroturnaround.common.args.store.ITransientArgStore;
import org.zeroturnaround.common.xml.XmlUtil;
import org.zeroturnaround.common.xml.search.DomNamePredicate;
import org.zeroturnaround.common.xml.search.DomNameWithAnyTextContentPredicate;
import org.zeroturnaround.common.xml.search.DomSearcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishXmlArgStore
implements IPersistentArgStore,
ITransientArgStore<String> {
    private static final ArgFormatter ARG_FORMATTER = ArgFormatter.ID;
    private static final Map<String, String> DTD = new HashMap<String, String>();
    private final File domainXmlFile;
    private final Document domainXml;
    private List<Node> javaConfigNodes;

    public GlassFishXmlArgStore(File domainXmlFile) {
        this.domainXmlFile = domainXmlFile;
        this.domainXml = XmlUtil.loadXmlFile(domainXmlFile, GlassFishXmlArgStore.getSunEntityResolver());
        this.javaConfigNodes = GlassFishXmlArgStore.getJavaConfigNodes(this.domainXml);
    }

    @Override
    public void apply(ArgChanges changes) {
        this.applyRemovals(changes);
        this.applyAdditions(changes);
        GlassFishXmlArgStore.writeDomainXml(this.domainXml, this.domainXmlFile);
    }

    @Override
    public String preview(ArgChanges changes) {
        this.applyRemovals(changes);
        this.applyAdditions(changes);
        return GlassFishXmlArgStore.writeDomainXmlToString(this.domainXml);
    }

    private void applyRemovals(ArgChanges changes) {
        List<IArgument> allChanges = changes.all();
        for (Node javaConfig : this.javaConfigNodes) {
            for (Node jvmOption : GlassFishXmlArgStore.getJVMOptions(javaConfig)) {
                for (IArgument arg : allChanges) {
                    if (!arg.matches(jvmOption.getTextContent())) continue;
                    try {
                        javaConfig.removeChild(jvmOption);
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private void applyAdditions(ArgChanges changes) {
        for (Node javaConfig : this.javaConfigNodes) {
            for (IArgument arg : changes.additions) {
                String rendered = arg.asString(ARG_FORMATTER);
                javaConfig.appendChild(this.domainXml.createElement("jvm-options")).appendChild(this.domainXml.createTextNode(rendered));
            }
        }
    }

    @Override
    public boolean contains(IArgument target) {
        return this.findFirst(target).isDefined();
    }

    @Override
    public Maybe<IArgument> findFirst(IArgument target) {
        for (Node javaConfig : this.javaConfigNodes) {
            for (Node jvmOption : GlassFishXmlArgStore.getJVMOptions(javaConfig)) {
                String arg = jvmOption.getTextContent();
                if (!target.matches(arg)) continue;
                return Maybe.some(target.fromString(arg));
            }
        }
        return Maybe.none();
    }

    @Override
    public List<IArgument> findAll(IArgument target) {
        ArrayList<IArgument> foundArgs = new ArrayList<IArgument>();
        for (Node javaConfig : this.javaConfigNodes) {
            for (Node jvmOption : GlassFishXmlArgStore.getJVMOptions(javaConfig)) {
                String arg = jvmOption.getTextContent();
                if (!target.matches(arg)) continue;
                foundArgs.add(target.fromString(arg));
            }
        }
        return foundArgs;
    }

    private static List<Node> getJVMOptions(Node javaConfig) {
        return DomSearcher.findRecursively(javaConfig, new DomNameWithAnyTextContentPredicate("jvm-options"));
    }

    private static List<Node> getJavaConfigNodes(Document domainXmlDoc) {
        List<Node> nodes = DomSearcher.findRecursively(domainXmlDoc, new DomNamePredicate("java-config"));
        XmlUtil.debugNodes(nodes);
        return nodes;
    }

    private static EntityResolver getSunEntityResolver() {
        return new EntityResolver(){

            public InputSource resolveEntity(String pid, String sid) throws SAXException {
                if (DTD.containsKey(sid)) {
                    InputStream stream = GlassFishXmlArgStore.class.getResourceAsStream((String)DTD.get(sid));
                    return new InputSource(stream);
                }
                throw new SAXException("unable to resolve remote entity, sid = " + sid);
            }
        };
    }

    private static String writeDomainXmlToString(Document domainXml) {
        Transformer transformer = XmlUtil.getDefaultTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        DocumentType dt = domainXml.getDoctype();
        if (null != dt) {
            transformer.setOutputProperty("doctype-public", dt.getPublicId());
            transformer.setOutputProperty("doctype-system", dt.getSystemId());
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XmlUtil.writeXml(domainXml, bos, transformer);
        String encoding = domainXml.getInputEncoding();
        try {
            return encoding != null ? bos.toString(encoding) : bos.toString();
        }
        catch (UnsupportedEncodingException e) {
            return bos.toString();
        }
    }

    private static void writeDomainXml(Document domainXml, File domainXmlFile) {
        Transformer transformer = XmlUtil.getDefaultTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("omit-xml-declaration", "no");
        DocumentType dt = domainXml.getDoctype();
        if (null != dt) {
            transformer.setOutputProperty("doctype-public", dt.getPublicId());
            transformer.setOutputProperty("doctype-system", dt.getSystemId());
        }
        XmlUtil.writeXmlFile(domainXml, domainXmlFile, transformer);
    }

    static {
        DTD.put("http://www.sun.com/software/appserver/dtds/sun-domain_1_3.dtd", "sun-domain_1_3.dtd");
        DTD.put("http://www.sun.com/software/appserver/dtds/sun-domain_1_4.dtd", "sun-domain_1_4.dtd");
        DTD.put("http://www.sun.com/software/appserver/dtds/sun-domain_1_5.dtd", "sun-domain_1_5.dtd");
    }
}

