/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.args.store;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.ArgFormatter;
import org.zeroturnaround.common.args.IArgument;
import org.zeroturnaround.common.args.store.ITransientArgStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringListArgStore
implements ITransientArgStore<List<String>> {
    private final List<String> original;
    private final ArgFormatter formatter;

    public StringListArgStore(List<String> original, ArgFormatter formatter) {
        this.original = original;
        this.formatter = formatter;
    }

    @Override
    public List<String> preview(ArgChanges changes) {
        ArrayList<String> result = new ArrayList<String>(this.original);
        this.applyRemovals(changes, result);
        this.applyAdditions(changes, result);
        return result;
    }

    private void applyRemovals(ArgChanges changes, List<String> result) {
        List<IArgument> allChanges = changes.all();
        Iterator<String> iter = result.iterator();
        block0: while (iter.hasNext()) {
            String exArg = iter.next();
            for (IArgument arg : allChanges) {
                if (!arg.matches(exArg)) continue;
                iter.remove();
                continue block0;
            }
        }
    }

    private void applyAdditions(ArgChanges changes, List<String> result) {
        for (IArgument arg : changes.additions) {
            String rendered = arg.asString(this.formatter);
            result.add(0, rendered);
        }
    }

    @Override
    public boolean contains(IArgument target) {
        return this.findFirst(target).isDefined();
    }

    @Override
    public Maybe<IArgument> findFirst(IArgument target) {
        for (String arg : this.original) {
            if (!target.matches(arg)) continue;
            return Maybe.some(target.fromString(arg));
        }
        return Maybe.none();
    }

    @Override
    public List<IArgument> findAll(IArgument target) {
        ArrayList<IArgument> foundArgs = new ArrayList<IArgument>();
        for (String arg : this.original) {
            if (!target.matches(arg)) continue;
            foundArgs.add(target.fromString(arg));
        }
        return foundArgs;
    }
}

