/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.jvm;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.zeroturnaround.common.jvm.JVMUtil;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.common.jvm.JavaVM2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CurrentJVM
implements JavaVM,
JavaVM2 {
    private final Map<String, String> properties = new HashMap<String, String>();
    private final String pathToJava;
    private final String javaVersion;

    public CurrentJVM() {
        String[] props;
        String[] arr$ = props = new String[]{"java.home", "java.version", "java.vendor", "java.vm.name", "java.vm.version", "java.vm.info", "java.vm.vendor", "os.arch"};
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String prop;
            String value = System.getProperty(prop = arr$[i$]);
            this.properties.put(prop, value != null ? value : "");
        }
        this.pathToJava = JVMUtil.getPathToJava(new File(this.properties.get("java.home"))).getOrElse("java");
        this.javaVersion = this.properties.get("java.version");
    }

    @Override
    public String pathToJavaExe() {
        return this.pathToJava;
    }

    @Override
    public Map<String, String> getVersionProperties() {
        return this.properties;
    }

    @Override
    public boolean isIBM() {
        return this.properties.get("java.vendor").contains("IBM");
    }

    @Override
    public boolean needsRebelBootstrap() {
        return this.isIBM() || !this.isJava5OrLater();
    }

    @Override
    public long lastModified() {
        return Long.MAX_VALUE;
    }

    @Override
    public String getJavaVersion() {
        return this.javaVersion;
    }

    @Override
    public boolean isJava5OrLater() {
        String ver = this.getJavaVersion();
        return ver == null || !ver.startsWith("1.4");
    }

    @Override
    public boolean isJava6OrLater() {
        String ver = this.getJavaVersion();
        return ver == null || !ver.startsWith("1.4") && !ver.startsWith("1.5");
    }

    @Override
    public String getDetailedVersion() {
        String vmName = this.properties.get("java.vm.name");
        String vmVersion = this.properties.get("java.vm.version");
        String vmInfo = this.properties.get("java.vm.info");
        String vmVendor = this.properties.get("java.vm.vendor");
        String osArch = this.properties.get("os.arch");
        return JVMUtil.getDetailedJavaVersion(vmName, vmVersion, vmInfo, vmVendor, osArch);
    }
}

