/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.jvm;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.zeroturnaround.common.Maybe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVMUtil {
    public static final String JAVA_HOME = "java.home";
    public static final String JAVA_VERSION = "java.version";
    public static final String JAVA_VENDOR = "java.vendor";
    public static final String JAVA_VM_NAME = "java.vm.name";
    public static final String JAVA_VM_VERSION = "java.vm.version";
    public static final String JAVA_VM_INFO = "java.vm.info";
    public static final String JAVA_VM_VENDOR = "java.vm.vendor";
    public static final String OS_ARCH = "os.arch";
    private static final Pattern IBM_VM_INFO = Pattern.compile("\\d{8}_\\d+");
    private static final String[] candidateJavaFiles = new String[]{"java", "java.exe", "j9", "j9.exe"};
    private static final String[] candidateJavaLocations = new String[]{"jre" + File.separatorChar + "bin" + File.separatorChar, "bin" + File.separatorChar};

    public static String getPathToJavaFallback() {
        String javaHomeProp = System.getProperty(JAVA_HOME);
        File javaHome = javaHomeProp != null ? new File(javaHomeProp) : null;
        return JVMUtil.getPathToJava(javaHome).getOrElse("java");
    }

    public static Maybe<String> getPathToJava(File installLocation) {
        File javaExe;
        if (installLocation != null && (javaExe = JVMUtil.findJavaExecutable(installLocation)) != null) {
            return Maybe.some(javaExe.getAbsolutePath());
        }
        return Maybe.none();
    }

    public static File findJavaExecutable(File vmInstallLocation) {
        for (int i = 0; i < candidateJavaFiles.length; ++i) {
            for (int j = 0; j < candidateJavaLocations.length; ++j) {
                File javaFile = new File(vmInstallLocation, candidateJavaLocations[j] + candidateJavaFiles[i]);
                if (!javaFile.isFile()) continue;
                return javaFile;
            }
        }
        return null;
    }

    public static String getDetailedJavaVersion(String vmName, String vmVersion, String vmInfo, String vmVendor, String osArch) {
        Matcher m;
        if (vmVendor != null && vmVendor.contains("IBM") && (m = IBM_VM_INFO.matcher(vmInfo)).find()) {
            vmInfo = m.group();
        }
        String jrebelArch = osArch == null || osArch.contains("64") ? "64" : "32";
        return vmName + "_" + vmVersion + "_" + vmInfo + "_" + jrebelArch;
    }
}

