/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.jvm;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.zeroturnaround.common.exec.SafeExec;
import org.zeroturnaround.common.jvm.JVMUtil;
import org.zeroturnaround.common.jvm.JavaHomeJVM;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.common.jvm.JavaVM2;
import org.zeroturnaround.common.xml.XmlUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaExeJVM
implements JavaVM,
JavaVM2 {
    private static final Pattern JAVA_VERSION = Pattern.compile("java version \"(.*?)\"");
    private final File tmpDir;
    private final String pathToJava;
    private String javaVersion;
    private final Map<String, String> javaProps = new HashMap<String, String>();
    private final long lastModified;

    public JavaExeJVM(String pathToJava, File tmpDir) {
        this.pathToJava = pathToJava;
        long lastModified = 0L;
        if (!"java".equals(pathToJava)) {
            try {
                lastModified = new File(pathToJava).getCanonicalFile().lastModified();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        this.lastModified = lastModified;
        this.tmpDir = tmpDir;
    }

    @Override
    public String pathToJavaExe() {
        return this.pathToJava;
    }

    @Override
    public long lastModified() {
        return this.lastModified;
    }

    @Override
    public boolean isIBM() {
        try {
            return this.evaluateSystemProperty("java.vendor").contains("IBM");
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    public boolean needsRebelBootstrap() {
        return this.isIBM() || !this.isJava5OrLater();
    }

    @Override
    public synchronized String getJavaVersion() {
        if (this.javaVersion != null) {
            return this.javaVersion;
        }
        try {
            SafeExec.ExecResult result = SafeExec.execute(this.pathToJavaExe(), "-version");
            String text = result.output.length() > 0 ? result.output : result.errorOutput;
            Matcher m = JAVA_VERSION.matcher(text);
            if (m.find()) {
                this.javaVersion = m.group(1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.javaVersion;
    }

    @Override
    public String getDetailedVersion() {
        Map<String, String> props = this.getVersionProperties();
        String vmName = props.get("java.vm.name");
        String vmVersion = props.get("java.vm.version");
        String vmInfo = props.get("java.vm.info");
        String vmVendor = props.get("java.vm.vendor");
        String osArch = props.get("os.arch");
        return JVMUtil.getDetailedJavaVersion(vmName, vmVersion, vmInfo, vmVendor, osArch);
    }

    @Override
    public Map<String, String> getVersionProperties() {
        try {
            return this.evaluateSystemProperties("java.vm.name", "java.vm.version", "java.vm.info", "java.vm.vendor", "os.arch");
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
    }

    public String evaluateSystemProperty(String property) throws IOException {
        Map<String, String> props = this.evaluateSystemProperties(property);
        return props.get(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> evaluateSystemProperties(String ... properties) throws IOException {
        boolean containsAll = true;
        for (String prop : properties) {
            if (this.javaProps.containsKey(prop)) continue;
            containsAll = false;
            break;
        }
        if (containsAll) {
            return this.javaProps;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        File launchingSupportJar = new File(this.tmpDir, "launchingsupport.jar");
        if (!launchingSupportJar.exists() || launchingSupportJar.length() == 0L) {
            InputStream jarStream = JavaHomeJVM.class.getClassLoader().getResourceAsStream("lib/launchingsupport.jar");
            if (jarStream == null) {
                throw new IllegalStateException("lib/launchingsupport.jar not found");
            }
            try {
                FileOutputStream outStream = FileUtils.openOutputStream(launchingSupportJar);
                try {
                    IOUtils.copy(jarStream, (OutputStream)outStream);
                }
                finally {
                    IOUtils.closeQuietly(outStream);
                }
            }
            finally {
                IOUtils.closeQuietly(jarStream);
            }
        }
        if (!launchingSupportJar.exists()) {
            throw new IOException("launchingsupport.jar not found at " + launchingSupportJar);
        }
        String mainType = "org.eclipse.jdt.internal.launching.support.SystemProperties";
        ArrayList<String> allArgs = new ArrayList<String>();
        allArgs.addAll(Arrays.asList(this.pathToJava, "-cp", launchingSupportJar.getAbsolutePath(), mainType));
        allArgs.addAll(Arrays.asList(properties));
        SafeExec.ExecResult result = SafeExec.execute(allArgs.toArray(new String[allArgs.size()]));
        String text = result.output;
        if (text != null && text.length() > 0) {
            Document document = XmlUtil.loadXml(text);
            Element envs = document.getDocumentElement();
            NodeList list = envs.getChildNodes();
            int length = list.getLength();
            for (int i = 0; i < length; ++i) {
                Element element;
                Node node = list.item(i);
                short type = node.getNodeType();
                if (type != 1 || !(element = (Element)node).getNodeName().equals("property")) continue;
                String name = element.getAttribute("name");
                String value = element.getAttribute("value");
                map.put(name, value);
            }
            for (String prop : properties) {
                if (map.containsKey(prop)) continue;
                map.put(prop, null);
            }
            this.javaProps.putAll(map);
        }
        return map;
    }

    @Override
    public boolean isJava5OrLater() {
        String ver = this.getJavaVersion();
        return ver == null || !ver.startsWith("1.4");
    }

    @Override
    public boolean isJava6OrLater() {
        String ver = this.getJavaVersion();
        return ver == null || !ver.startsWith("1.4") && !ver.startsWith("1.5");
    }
}

