/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.options;

import java.io.File;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.common.ListenerList;
import org.zeroturnaround.common.options.BooleanOption;
import org.zeroturnaround.common.options.FileOption;
import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.options.IValueChangedListener;
import org.zeroturnaround.common.options.IntegerOption;
import org.zeroturnaround.common.options.ReadOnlyOption;
import org.zeroturnaround.common.options.StringOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Option<T>
implements IOption<T> {
    private static final Logger log = LoggerFactory.getLogger(Option.class);
    private T value;
    protected final String name;
    private final T defaultValue;
    private boolean writeDefault = false;
    private ListenerList<IValueChangedListener<T>> listeners = new ListenerList();

    protected Option(String name, T value, T defaultValue) {
        this.name = name;
        this.value = value;
        this.defaultValue = defaultValue;
    }

    public static Option<Boolean> boolWithDefault(String name, Boolean defaultValue) {
        return new BooleanOption(name, defaultValue, defaultValue);
    }

    public static Option<Integer> intWithDefault(String name, Integer defaultValue) {
        return new IntegerOption(name, defaultValue, defaultValue);
    }

    public static Option<String> stringWithDefault(String name, String defaultValue) {
        return new StringOption(name, defaultValue, defaultValue);
    }

    public static Option<File> file(String name) {
        return new FileOption(name, null, null);
    }

    public static Option<File> fileWithDefault(String name, File defaultValue) {
        return new FileOption(name, defaultValue, defaultValue);
    }

    public static Option<File> fileWithDefaultForceSave(String name, File defaultValue) {
        return new FileOption(name, defaultValue, defaultValue){

            public void saveIn(Properties props) {
                if (this.isDefault() || this.getValue() == null) {
                    props.put(this.name, ((File)this.getDefaultValue()).toString());
                } else {
                    props.put(this.name, ((File)this.getValue()).toString());
                }
            }
        };
    }

    public static <T> ReadOnlyOption<T> readOnly(T value) {
        return new ReadOnlyOption<T>(value);
    }

    @Override
    public boolean isDefault() {
        return this.value == null && this.defaultValue == null || this.value != null && this.value.equals(this.defaultValue);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public T getValueOrDefault() {
        return this.value != null ? this.value : this.defaultValue;
    }

    public void setWriteDefault(boolean writeDefault) {
        this.writeDefault = writeDefault;
    }

    public boolean getWriteDefault() {
        return this.writeDefault;
    }

    public String getValueOrDefaultAsString() {
        T val = this.getValueOrDefault();
        return val == null ? null : val.toString();
    }

    @Override
    public void setValue(T value) {
        T oldValue = this.value;
        this.value = value;
        if (oldValue == null && value != null || oldValue != null && !oldValue.equals(value)) {
            this.notifyListeners();
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public void addValueChangedListener(IValueChangedListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeValueChangedListener(IValueChangedListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        for (IValueChangedListener<T> listener : this.listeners.getListeners()) {
            try {
                listener.valueChanged(this);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    public void saveIn(Properties props) {
        if (!this.writeDefault && this.isDefault() || this.value == null) {
            props.remove(this.name);
        } else {
            props.put(this.name, this.value.toString());
        }
    }

    public abstract void loadFrom(Properties var1);
}

