/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.options;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.common.ListenerList;
import org.zeroturnaround.common.options.IOption;
import org.zeroturnaround.common.options.IValueChangedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReadOnlyOption<T>
implements IOption<T> {
    private static final Logger log = LoggerFactory.getLogger(ReadOnlyOption.class);
    private T value;
    private ListenerList<IValueChangedListener<T>> listeners = new ListenerList();

    public ReadOnlyOption(T value) {
        this.value = value;
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public T getValueOrDefault() {
        return this.value;
    }

    @Override
    public void setValue(T value) {
        throw new UnsupportedOperationException();
    }

    public void forceSetValue(T value) {
        this.value = value;
        this.notifyListeners();
    }

    @Override
    public boolean isDefault() {
        return true;
    }

    @Override
    public T getDefaultValue() {
        return this.value;
    }

    @Override
    public void addValueChangedListener(IValueChangedListener<T> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeValueChangedListener(IValueChangedListener<T> listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners() {
        for (IValueChangedListener<T> listener : this.listeners.getListeners()) {
            try {
                listener.valueChanged(this);
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
    }
}

