/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.server.jboss;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.exec.SafeExec;
import org.zeroturnaround.common.util.FileUtilsBackports;
import org.zeroturnaround.jrebel.client.common.EnvironmentUtil;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossVariables {
    private static final String JAVA_HOME = "JAVA_HOME";
    private final File serverHome;
    private final File tmpDir;
    private final Map<String, String> env;
    private final String scriptName;

    public JBossVariables(File serverHome, String scriptName, File tmpDir, Map<String, String> env) {
        this.serverHome = serverHome;
        this.tmpDir = tmpDir;
        this.env = env;
        this.scriptName = scriptName;
    }

    public Maybe<String> getJavaHome() {
        return this.resolveVariableFromEnv(JAVA_HOME, this.env);
    }

    public Maybe<String> resolveVariableFromEnv(String name, Map<String, String> env) {
        try {
            boolean windows = EnvironmentUtil.isWindows();
            String ext = windows ? ".conf.bat" : ".conf";
            File resolverScript = this.makeResolverScript(name, windows);
            String confScript = new File(this.serverHome, "bin/" + this.scriptName + ext).getAbsolutePath();
            SafeExec.ExecResult result = SafeExec.execute(env, resolverScript.getAbsolutePath(), confScript);
            return Maybe.some(result.lastLineOfOutput());
        }
        catch (IOException e) {
            JRebelClientAdapter.getInstance().error(e);
            return Maybe.none();
        }
    }

    private File makeResolverScript(String name, boolean windows) throws IOException {
        String command = null;
        command = windows ? "@echo off\n@if exist \"%1\" call \"%1\"\n@echo %" + name + "%" : "if [ -r \"$1\" ]; then\n . \"$1\"\nfi\necho $" + name;
        String ext = windows ? ".bat" : ".sh";
        File resolverScript = new File(this.tmpDir, "resolve_env_jboss_" + name + ext);
        FileUtils.writeStringToFile(resolverScript, command);
        FileUtilsBackports.setExecutable(resolverScript, true);
        return resolverScript;
    }

    public static void main(String[] args) {
        JBossVariables vars = new JBossVariables(new File("C:/opt/containers/jboss-6.1.0.Final"), "run", new File("C:/tmp"), Collections.<String, String>emptyMap());
        Maybe<String> javaHome = vars.getJavaHome();
        if (javaHome.isDefined()) {
            System.out.println("JAVA_HOME=" + javaHome.get());
        }
    }
}

