/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.server.tomcat;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.zeroturnaround.common.Maybe;
import org.zeroturnaround.common.exec.SafeExec;
import org.zeroturnaround.common.jvm.JavaHomeJVM;
import org.zeroturnaround.common.server.JavaHomeResolver;
import org.zeroturnaround.common.util.FileUtilsBackports;
import org.zeroturnaround.jrebel.client.common.EnvironmentUtil;
import org.zeroturnaround.jrebel.client.spi.JRebelClientAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatalinaJavaHomeResolver
implements JavaHomeResolver {
    private static final String JRE_HOME = "JRE_HOME";
    private final File serverHome;
    private final File tmpDir;
    private final Map<String, String> env;

    public CatalinaJavaHomeResolver(File serverHome, File tmpDir, Map<String, String> env) {
        this.serverHome = serverHome;
        this.tmpDir = tmpDir;
        this.env = env;
    }

    @Override
    public Maybe<String> getJavaHome() {
        try {
            boolean windows = EnvironmentUtil.isWindows();
            String ext = windows ? ".bat" : ".sh";
            File resolverScript = this.makeResolverScript(JRE_HOME, windows);
            String setenv = new File(this.serverHome, "bin/setenv" + ext).getAbsolutePath();
            String setclasspath = new File(this.serverHome, "bin/setclasspath" + ext).getAbsolutePath();
            SafeExec.ExecResult result = SafeExec.execute(this.env, resolverScript.getAbsolutePath(), setenv, setclasspath);
            String javaHome = result.lastLineOfOutput();
            return JavaHomeJVM.isValid(javaHome) ? Maybe.some(javaHome) : Maybe.none();
        }
        catch (IOException e) {
            JRebelClientAdapter.getInstance().error(e);
            return Maybe.none();
        }
    }

    private File makeResolverScript(String name, boolean windows) throws IOException {
        String command = null;
        command = windows ? "@echo off\nSET CLASSPATH=\nif exist \"%1\" call \"%1\"\ncall \"%2\"\necho %" + name + "%" : "CLASSPATH=\nif [ -r \"$1\" ]; then\n . \"$1\"\nfi\n. \"$2\"\necho $" + name;
        String ext = windows ? ".bat" : ".sh";
        File resolverScript = new File(this.tmpDir, "resolve_JAVA_HOME_catalina" + ext);
        FileUtils.writeStringToFile(resolverScript, command);
        FileUtilsBackports.setExecutable(resolverScript, true);
        return resolverScript;
    }

    public static void main(String[] args) {
        CatalinaJavaHomeResolver vars = new CatalinaJavaHomeResolver(new File("M:/opt/apache-tomcat-7.0.12"), new File("C:/tmp"), Collections.<String, String>emptyMap());
        Maybe<String> javaHome = vars.getJavaHome();
        if (javaHome.isDefined()) {
            System.out.println("JAVA_HOME=" + javaHome.get());
        }
    }
}

