/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.common.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlUtil {
    public static Document loadXml(String text) {
        try {
            DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
            df.setNamespaceAware(false);
            DocumentBuilder dc = df.newDocumentBuilder();
            return dc.parse(new ByteArrayInputStream(text.getBytes()));
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Document newDoc() {
        try {
            DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
            df.setNamespaceAware(false);
            DocumentBuilder dc = df.newDocumentBuilder();
            return dc.newDocument();
        }
        catch (ParserConfigurationException e) {
            return null;
        }
    }

    public static Document loadXmlFile(File xmlFile, EntityResolver resolver) {
        try {
            DocumentBuilderFactory df = DocumentBuilderFactory.newInstance();
            df.setNamespaceAware(true);
            DocumentBuilder dc = df.newDocumentBuilder();
            if (resolver != null) {
                dc.setEntityResolver(resolver);
            }
            Document doc = dc.parse(xmlFile);
            return doc;
        }
        catch (Exception e) {
            throw new RuntimeException("Xml file loading failed!", e);
        }
    }

    public static Document loadXmlFile(File xmlFile) {
        return XmlUtil.loadXmlFile(xmlFile, null);
    }

    public static void writeXmlFile(Document document, File outputFile, Transformer transformer) {
        try {
            transformer.transform(new DOMSource(document), new StreamResult(outputFile));
        }
        catch (TransformerException e) {
            throw new RuntimeException("XML transformation exception!", e);
        }
    }

    public static String writeXmlToString(Document document, Transformer transformer) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(document), new StreamResult(out));
            String encoding = document.getInputEncoding();
            try {
                return encoding != null ? out.toString(encoding) : out.toString();
            }
            catch (UnsupportedEncodingException e) {
                return out.toString();
            }
        }
        catch (TransformerException e) {
            throw new RuntimeException("XML transformation exception!", e);
        }
    }

    public static void writeXml(Document document, OutputStream stream, Transformer transformer) {
        try {
            transformer.transform(new DOMSource(document), new StreamResult(stream));
        }
        catch (TransformerException e) {
            throw new RuntimeException("XML transformation exception!", e);
        }
    }

    public static String writeXmlToString(Document document) {
        return XmlUtil.writeXmlToString(document, XmlUtil.getDefaultTransformer());
    }

    public static void writeXmlFile(Document document, File outputFile) {
        XmlUtil.writeXmlFile(document, outputFile, XmlUtil.getDefaultTransformer());
    }

    public static Transformer getDefaultTransformer() {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            return factory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException("Exception when initializing XML transformer!", e);
        }
    }

    public static void debugNodes(List<Node> nodes) {
        for (Node node : nodes) {
            XmlUtil.debugNode(node);
        }
    }

    public static void debugNode(Node node) {
        NamedNodeMap attrs = node.getAttributes();
        StringBuffer sb = new StringBuffer("[");
        int attrsLength = attrs.getLength();
        for (int i = 0; i < attrsLength; ++i) {
            sb.append(" ");
            Node attr = attrs.item(i);
            sb.append(attr.getNodeName() + "=\"" + attr.getNodeValue() + "\"");
        }
        sb.append("]");
        XmlUtil.debug(" -- node [NAME=" + node.getNodeName() + " ; TEXT-CONTENT=" + node.getTextContent() + " ; ATTRS=" + sb.toString() + "]");
    }

    private static void debug(String msg) {
    }
}

