/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.exec;

import java.io.UnsupportedEncodingException;

public class ProcessResult {
    private final int exitValue;
    private final byte[] output;

    public ProcessResult(int exitCode, byte[] output) {
        this.exitValue = exitCode;
        this.output = output;
    }

    public int exitValue() {
        return this.exitValue;
    }

    public byte[] output() {
        if (this.output == null) {
            throw new IllegalStateException("Process output was not read.");
        }
        return this.output;
    }

    public String outputString() {
        return new String(this.output());
    }

    public String outputUTF8() {
        return this.outputString("UTF-8");
    }

    public String outputString(String charset) {
        try {
            return new String(this.output(), charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }
}

