/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.javarebel;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.Calendar;

public interface Licensing {
    public static final int API_CODE_OK = 0;
    public static final int API_CODE_GENERAL_EXCEPTION = 1;
    public static final int API_CODE_LICENSING_EXCEPTION = 2;

    public boolean isEnterprise();

    public boolean isLiveRebelEnabled();

    public SDKLicenseInfo getCurrentLicense() throws ExpiredLicenseException;

    public SDKLicenseInfo activateFromKey(String var1) throws ActivationException, ExpiredLicenseException;

    public SDKLicenseInfo activateFromFile(File var1) throws ActivationException, ExpiredLicenseException;

    public SDKLicenseInfo validateFromKey(String var1) throws ActivationException, ExpiredLicenseException;

    public SDKLicenseInfo validateFromFile(File var1) throws ActivationException, ExpiredLicenseException;

    public void goOnline() throws ActivationException;

    public void goOffline(int var1) throws ActivationException;

    public static class ExpiredLicenseException
    extends ActivationException {
        private static final long serialVersionUID = 541L;

        public ExpiredLicenseException(SDKLicenseInfo info) {
            super(info);
            this.faultCode = 9;
        }
    }

    public static class ActivationException
    extends Exception {
        private static final long serialVersionUID = 541L;
        public static final int TEMP_FILE_WRITE = 1;
        public static final int LICENSE_FILE_WRITE = 2;
        public static final int INVALID_LICENSE = 3;
        public static final int PROPERTIES_FILE_WRITE = 4;
        public static final int LS2_CONNECT_FAILURE = 5;
        public static final int LS_NOT_CONFIGURED = 6;
        public static final int INVALID_KEY_STRING = 7;
        public static final int MYJREBEL_CONNECTION_ERROR = 8;
        public static final int LICENSE_EXPIRED = 9;
        public static final int MYJREBEL_LIMIT_EXCEEDED = 10;
        public static final int FILE_DOES_NOT_EXIST = 11;
        protected int faultCode;
        protected SDKLicenseInfo licenseInfo;
        protected String faultString;

        public ActivationException(SDKLicenseInfo info) {
            this(3, null, info.getErrorMessage());
            this.licenseInfo = info;
            this.faultString = info.getErrorMessage();
        }

        public ActivationException(int faultCode, Exception cause) {
            this(faultCode, cause, null);
        }

        public ActivationException(int faultCode, Exception cause, String faultString) {
            super(cause);
            this.faultCode = faultCode;
            this.faultString = faultString;
        }

        public int getFaultCode() {
            return this.faultCode;
        }

        public SDKLicenseInfo getLicenseInfo() {
            return this.licenseInfo;
        }

        public String getFaultString() {
            return this.faultString;
        }
    }

    public static interface SDKLicenseInfo
    extends Serializable {
        public static final String[] LICENSES = new String[]{"None", "myJRebel", "License server 1", "License server 2", "License file", "Evaluation"};
        public static final int LICENSE_TYPE_NONE = 0;
        public static final int LICENSE_TYPE_MYJREBEL = 1;
        public static final int LICENSE_TYPE_LSERVER1 = 2;
        public static final int LICENSE_TYPE_LSERVER2 = 3;
        public static final int LICENSE_TYPE_FILE = 4;
        public static final int LICENSE_TYPE_EVAL = 5;

        public int getLicenseType();

        public boolean isValid();

        public Calendar getValidFrom();

        public Calendar getValidUntil();

        public String getLicenseeName();

        public String getLicenseeOrganization();

        public String getAdditionalInfo();

        public String getEMail();

        public boolean isOfflineLease();

        public URI getLicenseLocation();

        public File getLicenseFile();

        public String getErrorMessage();

        public String getUid();
    }
}

