/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client;

import com.zeroturnaround.jrebel.conf.bus.plugin.PluginCache;
import com.zeroturnaround.jrebel.conf.bus.plugin.PluginInfo;
import com.zeroturnaround.jrebel.conf.bus.plugin.PluginUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.zeroturnaround.common.Version;
import org.zeroturnaround.common.args.ArgChanges;
import org.zeroturnaround.common.args.store.IArgStore;
import org.zeroturnaround.common.jvm.CurrentJVM;
import org.zeroturnaround.common.jvm.JavaVM;
import org.zeroturnaround.common.jvm.JavaVM2;
import org.zeroturnaround.jrebel.client.JRebelCoreInterface;
import org.zeroturnaround.jrebel.client.JRebelJar;
import org.zeroturnaround.jrebel.client.JRebelNativeAgent;
import org.zeroturnaround.jrebel.client.args.RebelArgs;
import org.zeroturnaround.jrebel.client.args.RebelArgsBuilder;
import org.zeroturnaround.jrebel.client.bootstrap.JRebelBootstrapUtil;
import org.zeroturnaround.jrebel.client.common.EnvironmentUtil;
import org.zeroturnaround.jrebel.client.common.JRebelCommon;
import org.zeroturnaround.jrebel.client.config.JRebelConfiguration;
import org.zeroturnaround.jrebel.client.licensing.JRebelLicensing;
import org.zeroturnaround.jrebel.client.licensing.JRebelLicensingCLI;
import org.zeroturnaround.jrebel.client.licensing.JRebelLicensingSameProcess;
import org.zeroturnaround.jrebel.client.spi.ProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRebel {
    protected static final String BOOTSTRAP_CACHE_DIR = "bootcache";
    private final JRebelJar jrebelJar;
    private Boolean griffin = null;
    private Version version = null;

    public JRebel(File jarFile) {
        this.jrebelJar = new JRebelJar(jarFile);
    }

    public File getJarFile() {
        return this.jrebelJar.getFile();
    }

    public boolean isEmbedded() {
        return false;
    }

    public synchronized boolean isGriffin() {
        if (this.griffin == null) {
            this.griffin = "Griffin".equals(this.jrebelJar.getJRebelImplementation());
        }
        return this.griffin;
    }

    public boolean hasNativeAgentFor(String osArch) {
        File libFolder = new File(this.jrebelJar.getFile().getParentFile(), "lib");
        boolean vm64bit = EnvironmentUtil.is64Bit(osArch);
        return libFolder.exists() && new JRebelNativeAgent(libFolder).agentLibForCurrentOS(vm64bit).isDefined();
    }

    public JRebelNativeAgent getNativeAgent() {
        File libFolder = new File(this.jrebelJar.getFile().getParentFile(), "lib");
        return new JRebelNativeAgent(libFolder);
    }

    public boolean supports(JavaVM vm) {
        return this.isGriffin() ? vm.isJava6OrLater() : true;
    }

    public boolean needsBootstrapWith(JavaVM vm) {
        return this.isGriffin() || vm.needsRebelBootstrap();
    }

    public URL getLocalReferenceManualUrl() {
        File docDir = new File(this.getJarFile().getParent(), "doc");
        File manual = new File(docDir, "index.html");
        try {
            return manual.exists() ? manual.toURI().toURL() : null;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public File getJRebelJarCopyDir() {
        return JRebelCommon.getUserHomeDir();
    }

    public File getBootstrapCacheDir() {
        return new File(JRebelCommon.getUserHomeDir(), BOOTSTRAP_CACHE_DIR);
    }

    public JRebelLicensing getLicensing(JRebelConfiguration config) {
        return this.getLicensing(config, new CurrentJVM(), "CLI");
    }

    public JRebelLicensing getLicensing(JRebelConfiguration config, String ideId) {
        return this.getLicensing(config, new CurrentJVM(), ideId);
    }

    public JRebelLicensing getLicensing(JRebelConfiguration config, JavaVM vm, String ideId) {
        if (this.hasCLILicensingAPI()) {
            return new JRebelLicensingCLI(config, this, vm, ideId);
        }
        this.jrebelJar.copyTo(this.getJRebelJarCopyDir());
        return new JRebelLicensingSameProcess(config, this.jrebelJar.getCopiedFile(), JRebelLicensing.class.getClassLoader(), ideId);
    }

    public JRebelCoreInterface getCoreInterface(String pathToJava) {
        return new JRebelCoreInterface(pathToJava, this.getJarFile().getAbsolutePath());
    }

    public File getBootstrapJarFile(JavaVM jvm, ProgressMonitor monitor) throws Exception {
        return new File(JRebelBootstrapUtil.getBootstrapPath(this, jvm, monitor));
    }

    public Collection<PluginInfo> getPluginInfos() {
        Collection<PluginInfo> pluginInfos = PluginCache.loadAllInfos(this.getJarFile());
        if (pluginInfos == null) {
            pluginInfos = PluginUtil.readAllInfos(this.getJarFile());
        }
        return pluginInfos;
    }

    public Version getVersion() {
        if (this.version == null) {
            this.version = this.jrebelJar.getVersion();
        }
        return this.version;
    }

    public String getImplementationVersion() {
        return this.jrebelJar.getImplementationTitle() + "-" + this.jrebelJar.getImplementationVersionString();
    }

    public String getVersionString() {
        return this.jrebelJar.getVersionString();
    }

    public String getFullVersionString() {
        return this.jrebelJar.getFullVersionString();
    }

    public boolean needsNoVerifyWithJavaagent() {
        return !this.isGriffin() && this.getVersion().getMajor() < 4;
    }

    public boolean hasStatisticsOption() {
        return new Version(5, 0, 1, null).compareTo(this.getVersion()) <= 0;
    }

    public boolean hasActivationAPI() {
        return new Version(5, 1, 4, null).compareTo(this.getVersion()) <= 0;
    }

    public boolean hasCLILicensingAPI() {
        return new Version(5, 4, 1, null).compareTo(this.getVersion()) <= 0;
    }

    public boolean supportsLicenseServer2() {
        return new Version(5, 1, 2, null).compareTo(this.getVersion()) <= 0;
    }

    public boolean supportsSingleLicenseValidation() {
        return new Version(5, 1, 2, null).compareTo(this.getVersion()) <= 0;
    }

    public ArgChanges getInstallationArguments(JavaVM vm, ProgressMonitor monitor) throws Exception {
        return this.getInstallationArgs(vm, monitor);
    }

    public ArgChanges getUndoInstallationArguments() {
        return this.getUndoInstallationArgs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArgChanges getInstallationArgs(JavaVM vm, ProgressMonitor monitor) throws Exception {
        try {
            JRebelConfiguration config = JRebelConfiguration.getDefault();
            RebelArgsBuilder args = new RebelArgsBuilder(this);
            if (this.isGriffin()) {
                boolean usingNativeAgent = false;
                String osArch = null;
                if ("true".equals(config.getCustomProperty("rebel.griffin.native_agent"))) {
                    if (vm instanceof JavaVM2) {
                        osArch = ((JavaVM2)((Object)vm)).getVersionProperties().get("os.arch");
                    }
                    usingNativeAgent = this.hasNativeAgentFor(osArch);
                }
                if (usingNativeAgent) {
                    this.getBootstrapJarFile(vm, monitor);
                    args.nativeAgent(EnvironmentUtil.is64Bit(osArch));
                } else {
                    args.bootClasspathWithoutAgentJar(this.getBootstrapJarFile(vm, monitor));
                    args.javaagent();
                }
            } else if (vm.needsRebelBootstrap()) {
                args.bootClasspathWithAgentJar(this.getBootstrapJarFile(vm, monitor));
                args.noverify();
            } else {
                args.javaagent();
                args.optNoverify();
            }
            args.proxySettings(config);
            args.changes.merge(this.getUndoInstallationArgs());
            ArgChanges argChanges = args.changes;
            return argChanges;
        }
        finally {
            monitor.done();
        }
    }

    protected ArgChanges getUndoInstallationArgs() {
        ArgChanges changes = new ArgChanges();
        File dummyFile = new File(".");
        changes.remove(RebelArgs.agent(dummyFile));
        changes.remove(RebelArgs.nativeAgent(dummyFile));
        changes.remove(RebelArgs.bootClasspath(new File[0]));
        changes.remove(RebelArgs.NOVERIFY);
        changes.remove(RebelArgs.SHARECLASSES_NONE);
        changes.remove(RebelArgs.rebelMetadataPath(dummyFile));
        JRebelConfiguration config = JRebelConfiguration.getDefault();
        changes.remove(RebelArgs.configFile(config));
        changes.remove(RebelArgs.logFile(config));
        changes.remove(RebelArgs.notificationUrl(""));
        return changes;
    }

    public boolean isEnabledIn(IArgStore argStore) {
        File dummyFile = new File(".");
        return argStore.contains(RebelArgs.agent(dummyFile)) || argStore.contains(RebelArgs.bootClasspath(new File[0])) || argStore.contains(RebelArgs.nativeAgent(dummyFile));
    }
}

