/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.jrebel.client;

import java.io.IOException;
import org.zeroturnaround.common.exec.SafeExec;

public class JRebelCoreInterface {
    private final String javaPath;
    private final String jrebelJar;

    public JRebelCoreInterface(String javaPath, String jrebelJar) {
        this.javaPath = javaPath;
        this.jrebelJar = jrebelJar;
    }

    public SafeExec.ExecResult executeCoreCommand(String[] vmArgs, String ... programArgs) throws IOException {
        String[] args = this.prepareArguments(vmArgs, programArgs);
        return SafeExec.execute(args);
    }

    public SafeExec.BinExecResult executeLicensingCommand(String[] vmArgs, String ... programArgs) throws IOException {
        String[] args = this.prepareArgumentsLicensingCLI(vmArgs, programArgs);
        return new SafeExec(null).execBinOut(SafeExec.EMPTY_ENV, args);
    }

    public SafeExec.ExecResult executeCoreCommandWithCharset(String charset, String[] vmArgs, String ... programArgs) throws IOException {
        String[] args = this.prepareArguments(vmArgs, programArgs);
        return new SafeExec(charset).exec(args);
    }

    private String[] prepareArguments(String[] vmArgs, String ... programArgs) {
        String[] args = new String[2 + vmArgs.length + 2 + programArgs.length];
        int vmArgsIndex = 2;
        int programArgsIndex = vmArgsIndex + vmArgs.length + 2;
        args[0] = this.javaPath;
        args[1] = "-Drebel.log=false";
        System.arraycopy(vmArgs, 0, args, vmArgsIndex, vmArgs.length);
        args[programArgsIndex - 2] = "-jar";
        args[programArgsIndex - 1] = this.jrebelJar;
        System.arraycopy(programArgs, 0, args, programArgsIndex, programArgs.length);
        return args;
    }

    private String[] prepareArgumentsLicensingCLI(String[] vmArgs, String ... programArgs) {
        String[] args = new String[2 + vmArgs.length + 3 + programArgs.length];
        int vmArgsIndex = 2;
        int programArgsIndex = vmArgsIndex + vmArgs.length + 3;
        args[0] = this.javaPath;
        args[1] = "-Drebel.log=false";
        System.arraycopy(vmArgs, 0, args, vmArgsIndex, vmArgs.length);
        args[programArgsIndex - 3] = "-cp";
        args[programArgsIndex - 2] = this.jrebelJar;
        args[programArgsIndex - 1] = "com.zeroturnaround.javarebel.CLILicensingAPIImpl";
        System.arraycopy(programArgs, 0, args, programArgsIndex, programArgs.length);
        return args;
    }
}

